/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record CharArrayLoadable(Loadable<Character> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<char[]>
{
    @Override
    public int getLength(char[] array) {
        return array.length;
    }

    @Override
    public char[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new char[]{this.base.convert(element, key, context).charValue()};
    }

    @Override
    public char[] convertArray(JsonArray array, String key, TypedMap context) {
        char[] result = new char[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context).charValue();
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(char[] object) {
        return this.base.serialize(Character.valueOf(object[0]));
    }

    @Override
    public void serializeAll(JsonArray array, char[] object) {
        for (char element : object) {
            array.add(this.base.serialize(Character.valueOf(element)));
        }
    }

    @Override
    public char[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        char[] array = new char[max];
        for (int i = 0; i < max; ++i) {
            array[i] = ((Character)this.base.decode(buffer, context)).charValue();
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, char[] array) {
        buffer.m_130130_(array.length);
        for (char element : array) {
            this.base.encode(buffer, Character.valueOf(element));
        }
    }

    @Override
    public <P> LoadableField<char[], P> defaultField(String key, char[] defaultValue, boolean serializeDefault, Function<P, char[]> getter) {
        return new DefaultingField<char[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<char[], P> emptyField(String key, boolean serializeEmpty, Function<P, char[]> getter) {
        return this.defaultField(key, new char[0], serializeEmpty, getter);
    }
}

