/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.transformer;

import java.util.List;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.data.content.ContentTableOfContents;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.book.transformer.IndexTransformer;

public abstract class BookTransformer {
    public static BookTransformer indexTranformer() {
        return IndexTransformer.INSTANCE;
    }

    public static BookTransformer contentTableTransformer() {
        return ContentTableTransformer.INSTANCE;
    }

    public static BookTransformer contentTableTransformerForSection(String sectionName) {
        return new ContentTableTransformer(sectionName);
    }

    public static BookTransformer paddingTransformer() {
        return ContentPadding.PaddingBookTransformer.INSTANCE;
    }

    public abstract void transform(BookData var1);

    protected static class ContentTableTransformer
    extends BookTransformer {
        public static final ContentTableTransformer INSTANCE = new ContentTableTransformer();
        private final String sectionToTransform;

        public ContentTableTransformer(String sectionToTransform) {
            this.sectionToTransform = sectionToTransform;
        }

        public ContentTableTransformer() {
            this.sectionToTransform = null;
        }

        @Override
        public void transform(BookData book) {
            int ENTRIES_PER_PAGE = 24;
            for (SectionData section : book.sections) {
                int i;
                List<PageData> sectionPages;
                int genPages;
                if (section.name.equals("index") || this.sectionToTransform != null && !section.name.equals(this.sectionToTransform) || (genPages = (int)Math.ceil((float)(sectionPages = IndexTransformer.filterHiddenPages(section.pages)).size() * 1.0f / 24.0f)) == 0) continue;
                PageData[] pages = new PageData[genPages];
                for (i = 0; i < pages.length; ++i) {
                    pages[i] = new PageData(true);
                    pages[i].name = "tableofcontents" + i;
                    TextData[] text = new TextData[i > pages.length - 1 ? 24 : sectionPages.size() - (genPages - 1) * 24];
                    for (int j = 0; j < text.length; ++j) {
                        text[j] = new TextData(i * 24 + j + 1 + ". " + sectionPages.get(i * 24 + j).getTitle());
                        text[j].action = "mantle:go-to-page-rtn " + section.name + "." + sectionPages.get((int)(i * 24 + j)).name;
                    }
                    pages[i].content = new ContentTableOfContents(i == 0 ? section.getTitle() : "", text);
                }
                for (i = pages.length - 1; i >= 0; --i) {
                    section.pages.add(0, pages[i]);
                }
            }
        }
    }
}

