/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CreateRecipe
extends RecipeBase {
    public CreateRecipe(ResourceLocation id, String group, @Nonnull ItemStack result, NonNullList<Ingredient> input) {
        super(id, group, result, input);
    }

    @Override
    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        EnumColour colour = EnumColour.WHITE;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                EnumColour c;
                ItemStack stack = inv.m_8020_(x + y * inv.m_39347_());
                if (stack.m_41619_() || (c = EnumColour.fromWoolStack((ItemStack)stack)) == null) continue;
                colour = c;
                break block0;
            }
        }
        Frequency frequency = new Frequency(colour, colour, colour);
        return frequency.writeToStack(super.assemble(inv, pRegistryAccess));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EnderStorageModContent.CREATE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CreateRecipe> {
        public CreateRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new CreateRecipe(recipeId, group, result, (NonNullList<Ingredient>)ingredients);
        }

        @Nullable
        public CreateRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new CreateRecipe(recipeId, s, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, CreateRecipe recipe) {
            buffer.m_130070_(recipe.group);
            for (Ingredient ingredient : recipe.input) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

