/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.items;

import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.zeith.squarry.blocks.entity.TilePoweredQuarry;
import org.zeith.squarry.init.ItemsSQ;
import org.zeith.squarry.items.ItemUpgrade;

public class ItemFortuneUpgrade
extends ItemUpgrade {
    private static final ItemFortuneUpgrade[] upgrades = new ItemFortuneUpgrade[3];
    public int lvl;

    public ItemFortuneUpgrade(int lvl) {
        super(new Item.Properties().m_41487_(1));
        if (upgrades[lvl] == null) {
            ItemFortuneUpgrade.upgrades[lvl] = this;
        }
        this.lvl = lvl;
        this.quarryUseMultiplier = 2.0f;
    }

    @Override
    public void addEnchantments(TilePoweredQuarry quarry, Map<Enchantment, Integer> enchantmentMap) {
        int fortune = 0;
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE1)) {
            ++fortune;
        }
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE2) && fortune == 1) {
            ++fortune;
        }
        if (ItemUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_FORTUNE3) && fortune == 2) {
            ++fortune;
        }
        enchantmentMap.put(Enchantments.f_44987_, fortune);
    }

    @Override
    public boolean isCompatible(TilePoweredQuarry quarry) {
        if (this.lvl > 0 && !ItemFortuneUpgrade.hasUpgrade(quarry, upgrades[this.lvl - 1])) {
            return false;
        }
        return !ItemFortuneUpgrade.hasUpgrade(quarry, this) && !ItemFortuneUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }

    @Override
    public boolean canStay(TilePoweredQuarry quarry, int index) {
        if (this.lvl > 0 && !ItemFortuneUpgrade.hasUpgrade(quarry, upgrades[this.lvl - 1])) {
            return false;
        }
        return !ItemFortuneUpgrade.hasUpgrade(quarry, ItemsSQ.UPGRADE_SILK);
    }
}

