/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.squarry.client;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.zeith.squarry.SQCommonProxy;
import org.zeith.squarry.SQConfig;
import org.zeith.squarry.api.energy.UniversalConverter;
import org.zeith.squarry.api.particle.ClientQuarryVortex;
import org.zeith.squarry.api.particle.ParticleVortex;
import org.zeith.squarry.blocks.entity.TileFuelQuarry;
import org.zeith.squarry.client.screen.ScreenFilter;
import org.zeith.squarry.inventory.ContainerFilter;
import org.zeith.squarry.inventory.ContainerFuelQuarry;
import org.zeith.squarry.inventory.ContainerPoweredQuarry;
import org.zeith.squarry.items.ItemUpgrade;

public class SQClientProxy
extends SQCommonProxy {
    public SQClientProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::tooltip);
    }

    private void clientSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(ContainerFilter.FILTER, ScreenFilter::new);
    }

    @Override
    public ParticleVortex createQuarryVortex(TileFuelQuarry quarry) {
        return new ClientQuarryVortex(quarry);
    }

    private void tooltip(ItemTooltipEvent e) {
        Item item;
        Player p = e.getEntity();
        if (p == null) {
            return;
        }
        ItemStack it = e.getItemStack();
        if (!it.m_41619_() && (item = it.m_41720_()) instanceof ItemUpgrade) {
            ItemUpgrade up = (ItemUpgrade)item;
            e.getToolTip().add(Component.m_237113_((String)I18n.m_118938_((String)"info.squarry.fuel_use_boost", (Object[])new Object[]{Float.valueOf((float)Math.round(up.quarryUseMultiplierClient * 1000.0f) / 1000.0f)})).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (p.f_36096_ instanceof ContainerFuelQuarry || p.f_36096_ instanceof ContainerPoweredQuarry) {
            int burnTime;
            AbstractContainerMenu m;
            TileFuelQuarry quarry = null;
            AbstractContainerMenu abstractContainerMenu = p.f_36096_;
            if (abstractContainerMenu instanceof ContainerFuelQuarry) {
                m = (ContainerFuelQuarry)abstractContainerMenu;
                quarry = m.tile;
            }
            if ((abstractContainerMenu = p.f_36096_) instanceof ContainerPoweredQuarry) {
                m = (ContainerPoweredQuarry)abstractContainerMenu;
                quarry = ((ContainerPoweredQuarry)m).tile;
            }
            if ((burnTime = ForgeHooks.getBurnTime((ItemStack)e.getItemStack(), null)) > 0) {
                float mod = quarry != null ? (float)quarry.getUsageMult() : 1.0f;
                e.getToolTip().add(Component.m_237115_((String)"info.squarry.blocks_broken").m_130940_(ChatFormatting.DARK_GRAY).m_130946_(": " + (int)(UniversalConverter.FT_QF((float)burnTime / mod) / (UniversalConverter.FT_QF(ForgeHooks.getBurnTime((ItemStack)COAL, null)) / SQConfig.getBlocksPerCoal()))));
                e.getToolTip().add(Component.m_237115_((String)"info.squarry.qfuel_use_boost").m_130940_(ChatFormatting.DARK_GRAY).m_130946_(" " + (int)(mod * 100.0f) + "%"));
            } else {
                e.getToolTip().add(Component.m_237115_((String)"info.squarry.not_fuel").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

