/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.rapid_leaf_decay.handlers;

import de.geheimagentnr1.minecraft_forge_api.events.ForgeEventHandlerInterface;
import de.geheimagentnr1.rapid_leaf_decay.config.ServerConfig;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayQueue;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayTask;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayWorker;
import de.geheimagentnr1.rapid_leaf_decay.helpers.LeavesHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class DecayWorkHandler
implements ForgeEventHandlerInterface {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final DecayQueue decayQueue = new DecayQueue();

    @SubscribeEvent
    public void handleServerStartingEvent(@NotNull ServerStartingEvent event) {
        this.decayQueue.init();
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)new DecayWorker(this.serverConfig, this.decayQueue));
    }

    @SubscribeEvent
    public void handleBlockNeighborNotifyEvent(@NotNull BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_46859_(pos)) {
                for (Direction direction : event.getNotifiedSides()) {
                    BlockPos directionPos = pos.m_121945_(direction);
                    BlockState directionState = level.m_8055_(directionPos);
                    if (!LeavesHelper.isValidDecayingLeaf(directionState) || !LeavesHelper.isNotPersistent(directionState)) continue;
                    this.decayQueue.add(new DecayTask(serverLevel, directionState, directionPos));
                }
            }
        }
    }

    public DecayWorkHandler(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

