/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.rapid_leaf_decay.decayer;

import de.geheimagentnr1.rapid_leaf_decay.config.ServerConfig;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayQueue;
import de.geheimagentnr1.rapid_leaf_decay.decayer.DecayTask;
import de.geheimagentnr1.rapid_leaf_decay.helpers.LeavesHelper;
import java.util.ArrayList;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.WorldWorkerManager;
import org.jetbrains.annotations.NotNull;

public class DecayWorker
implements WorldWorkerManager.IWorker {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final DecayQueue decayQueue;
    private int tickCount = 0;

    public boolean hasWork() {
        return true;
    }

    public boolean doWork() {
        ++this.tickCount;
        if (this.tickCount < this.serverConfig.getDecayDelay()) {
            return false;
        }
        this.tickCount = 0;
        for (DecayTask decayTask : this.decayQueue.getElementsAndReset()) {
            BlockPos pos;
            ServerLevel level;
            BlockState state = decayTask.getState();
            if (!LeavesHelper.isValidDecayingLeaf(state) || !(level = decayTask.getLevel()).m_46749_(pos = decayTask.getPos())) continue;
            this.calculateDistances(state, pos, level);
            level.m_8055_(pos).m_222972_(level, pos, level.m_213780_());
        }
        return this.serverConfig.getDecayDelay() == 0 && this.decayQueue.isNotEmpty();
    }

    private void calculateDistances(@NotNull BlockState start_state, @NotNull BlockPos start_pos, @NotNull ServerLevel level) {
        ArrayList<Object> toCalculateStates = new ArrayList<Object>();
        ArrayList<Object> toCalculatePoses = new ArrayList<Object>();
        TreeSet<Object> inQueuePoses = new TreeSet<Object>();
        toCalculateStates.add(start_state);
        toCalculatePoses.add(start_pos);
        inQueuePoses.add(start_pos);
        while (!toCalculateStates.isEmpty()) {
            BlockState toCalculateState = (BlockState)toCalculateStates.get(0);
            BlockPos toCalculatePos = (BlockPos)toCalculatePoses.get(0);
            ArrayList<BlockState> directionStates = new ArrayList<BlockState>();
            ArrayList<BlockPos> directionPoses = new ArrayList<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockState directionState;
                BlockPos directionPos = toCalculatePos.m_121945_(direction);
                if (!level.m_46749_(directionPos) || !LeavesHelper.isValidDecayingLeaf(directionState = level.m_8055_(directionPos)) || !LeavesHelper.isNotPersistent(directionState) || inQueuePoses.contains(directionPos)) continue;
                directionStates.add(directionState);
                directionPoses.add(directionPos);
            }
            if (this.calculateDistance(toCalculateState, toCalculatePos, level)) {
                toCalculateStates.addAll(directionStates);
                toCalculatePoses.addAll(directionPoses);
                inQueuePoses.addAll(directionPoses);
            }
            toCalculateStates.remove(0);
            toCalculatePoses.remove(0);
            inQueuePoses.remove(toCalculatePos);
        }
    }

    private boolean calculateDistance(@NotNull BlockState queueState, @NotNull BlockPos pos, @NotNull ServerLevel level) {
        Direction direction;
        BlockPos directionPos;
        int old_distance = LeavesHelper.getDistance(queueState);
        int distance = 7;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; !(i >= n || level.m_46749_(directionPos = pos.m_121945_(direction = directionArray[i])) && (distance = Math.min(distance, this.getDistance(level.m_8055_(directionPos)) + 1)) == 1); ++i) {
        }
        if (old_distance != distance) {
            level.m_46597_(pos, LeavesHelper.setDistance(level.m_8055_(pos), distance));
            return true;
        }
        return false;
    }

    private int getDistance(@NotNull BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return LeavesHelper.isValidDecayingLeaf(state) ? LeavesHelper.getDistance(state) : 7;
    }

    public DecayWorker(@NotNull ServerConfig serverConfig, @NotNull DecayQueue decayQueue) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (decayQueue == null) {
            throw new NullPointerException("decayQueue is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.decayQueue = decayQueue;
    }
}

