/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.modifier;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.xstopho.resourcelibrary.modifier.LootTableModifier;
import net.xstopho.resourcelibrary.registration.RegistryObject;

@Mod.EventBusSubscriber(modid="resourcelibrary", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeLootTableModifier
implements LootTableModifier {
    private static final List<Modifier> lootModifier = new LinkedList<Modifier>();
    private static final List<RangedModifier> rangedLootModifier = new LinkedList<RangedModifier>();

    @Override
    public void addToPool(RegistryObject<Item> item, float amount, float chance, ResourceLocation ... lootTables) {
        for (ResourceLocation lootTable : lootTables) {
            lootModifier.add(new Modifier(item, amount, chance, lootTable));
        }
    }

    @Override
    public void addToPool(RegistryObject<Item> item, float minAmount, float maxAmount, float chance, ResourceLocation ... lootTables) {
        for (ResourceLocation lootTable : lootTables) {
            rangedLootModifier.add(new RangedModifier(item, minAmount, maxAmount, chance, lootTable));
        }
    }

    @SubscribeEvent
    public static void init(LootTableLoadEvent event) {
        for (Modifier modifier : lootModifier) {
            if (!event.getName().equals((Object)modifier.lootTable())) continue;
            event.getTable().addPool(LootTableModifier.createLootPool((ItemLike)modifier.item().get(), modifier.chance(), modifier.amount()).m_79082_());
        }
        for (RangedModifier rangedModifier : rangedLootModifier) {
            if (!event.getName().equals((Object)rangedModifier.lootTable())) continue;
            event.getTable().addPool(LootTableModifier.createLootPool((ItemLike)rangedModifier.item().get(), rangedModifier.chance(), rangedModifier.minAmount(), rangedModifier.maxAmount()).m_79082_());
        }
    }

    private record Modifier(RegistryObject<Item> item, float amount, float chance, ResourceLocation lootTable) {
    }

    private record RangedModifier(RegistryObject<Item> item, float minAmount, float maxAmount, float chance, ResourceLocation lootTable) {
    }
}

