/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.data;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.data.IDataArray;
import org.zeith.hammerlib.api.data.IDataTree;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class JSONHelper {
    public static JSONObject computeObject(JSONObject root, String key) {
        if (root.has(key)) {
            return root.getJSONObject(key);
        }
        return root.put(key, new JSONObject()).getJSONObject(key);
    }

    public static JSONArray computeArray(JSONObject root, String key) {
        if (root.has(key)) {
            return root.getJSONArray(key);
        }
        return root.put(key, new JSONArray()).getJSONArray(key);
    }

    private static Object data(Object val) {
        if (val instanceof JSONObject) {
            JSONObject o = (JSONObject)val;
            return JSONHelper.dataView(o);
        }
        if (val instanceof JSONArray) {
            JSONArray a = (JSONArray)val;
            return JSONHelper.dataView(a);
        }
        return val;
    }

    public static IDataTree dataView(final JSONObject obj) {
        return new IDataTree(){

            @Override
            @Nullable
            public Object get(String key) {
                return JSONHelper.data(obj.opt(key));
            }

            @Override
            @NotNull
            public Set<String> keys() {
                return obj.keySet();
            }
        };
    }

    public static IDataArray dataView(final JSONArray obj) {
        return new IDataArray(){

            @Override
            @Nullable
            public Object get(int index) {
                return JSONHelper.data(obj.opt(index));
            }

            @Override
            public int length() {
                return obj.length();
            }
        };
    }
}

