/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigElement;

public class ConfigDecimal
extends ConfigElement<ConfigDecimal> {
    private DecimalValueRange range;
    private BigDecimal defaultValue;
    private BigDecimal value;
    private String commentWithNoRange;

    public ConfigDecimal(Runnable onChanged, ConfigToken<ConfigDecimal> token, String name) {
        super(onChanged, token, name);
        this.nameTerminator = c -> c == 61;
    }

    public ConfigDecimal withRange(DecimalValueRange range) {
        if (!Objects.equals(range, this.range) && this.onChanged != null) {
            if (this.commentWithNoRange != null) {
                this.range = range;
                this.withComment(this.commentWithNoRange);
            }
            this.onChanged.run();
        }
        this.range = range;
        this.setValue(this.value);
        return this;
    }

    public ConfigDecimal withDefault(BigDecimal value) {
        if (!this.range.test(value)) {
            throw new IllegalArgumentException("Default value does not match the range " + this.range);
        }
        this.defaultValue = value;
        return this;
    }

    public ConfigDecimal withDefault(double value) {
        return this.withDefault(BigDecimal.valueOf(value));
    }

    public void setValue(BigDecimal value) {
        if (this.range != null) {
            value = this.range.enclose(value);
        }
        if (!Objects.equals(this.value, value)) {
            this.value = value;
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }
    }

    @Override
    public BigDecimal getValue() {
        return this.value != null ? (this.range != null ? this.range.enclose(this.value) : this.value) : this.defaultValue;
    }

    public float getValueF() {
        return this.getValue().floatValue();
    }

    public double getValueD() {
        return this.getValue().doubleValue();
    }

    @Override
    public ConfigDecimal withComment(String comment) {
        this.commentWithNoRange = comment;
        return (ConfigDecimal)super.withComment(comment + " (Range: " + this.range + ")");
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        int r;
        reader.mark(1);
        StringBuilder digits = new StringBuilder();
        while ((r = reader.read()) >= 0) {
            if (r == 13) continue;
            if (r == 10 || r == 44 || r == 93 || r == 125 || Character.isWhitespace(r)) {
                reader.reset();
                this.setValue(new BigDecimal(digits.toString()));
                return true;
            }
            if (r >= 48 && r <= 57 || digits.length() == 0 && r == 45) {
                digits.append((char)r);
            } else if (r == 46) {
                digits.append('.');
            } else {
                reader.reset();
                throw new IOException(new NumberFormatException("Unexpected character '" + (char)r + "' while reading " + readerStack + "; Accumulated: " + digits));
            }
            reader.mark(1);
        }
        return false;
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        writer.write("" + this.getValue());
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeString(this.getValue().toString());
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.setValue(new BigDecimal(buf.readString()));
    }

    public String toString() {
        return "ConfigDecimal{defaultValue=" + this.defaultValue + ", value=" + this.value + ", name='" + this.name + "', comment='" + this.getEscapedComment() + "'}";
    }
}

