/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class JSONVisitor {
    public static Map<String, Object> expand(Object object, String delimiter, boolean includeTrees) {
        AtomicReference<BiConsumer<String, Object>> visitorRef = new AtomicReference<BiConsumer<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        BiConsumer<String, Object> visitor = (s, o0) -> {
            boolean tree = false;
            if (o0 instanceof JSONObject) {
                JSONObject o = (JSONObject)o0;
                JSONVisitor.visit(s + (s.isEmpty() ? "" : delimiter), o, (BiConsumer<String, Object>)((BiConsumer)visitorRef.get()));
                tree = true;
            } else if (o0 instanceof JSONArray) {
                JSONArray a = (JSONArray)o0;
                JSONVisitor.visit(s, a, (BiConsumer<String, Object>)((BiConsumer)visitorRef.get()));
                tree = true;
            }
            if (!tree || includeTrees) {
                map.put((String)s, o0);
            }
        };
        visitorRef.set(visitor);
        visitor.accept("", object);
        return map;
    }

    public static void visit(String prefix, JSONObject $, BiConsumer<String, Object> visitor) {
        for (String key : $.keySet()) {
            visitor.accept(prefix + key, $.get(key));
        }
    }

    public static void visit(String prefix, JSONArray $, BiConsumer<String, Object> visitor) {
        int l = $.size();
        for (int key = 0; key < l; ++key) {
            visitor.accept(prefix + "[" + key + "]", $.get(key));
        }
    }
}

