/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.shimmer;

import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.forge.event.ForgeShimmerReloadEvent;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.impl.IGlowingBlock;
import org.zeith.hammerlib.api.lighting.impl.IGlowingItem;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.hammerlib.compat.base.BaseCompat;
import org.zeith.hammerlib.compat.base._hl.BaseHLCompat;
import org.zeith.hammerlib.compat.base._hl.BloomAbilityBase;
import org.zeith.hammerlib.util.java.Cast;

@BaseCompat.LoadCompat(modid="shimmer", compatType=BaseHLCompat.class)
public class ShimmerCompat
extends BaseHLCompat {
    private static Set<IGlowingBlock> BLOCKS;
    private static Set<IGlowingItem> ITEMS;
    public final BloomAbilityBase bloom = new BloomAbilityBase(){

        @Override
        protected Supplier<Supplier<BloomAbilityBase.ClientBloomAbilityBase>> forClient() {
            return () -> () -> new BloomAbilityBase.ClientBloomAbilityBase(){

                @Override
                public RenderType emissiveTranslucentArmor(ResourceLocation resourceLocation) {
                    return RenderType.m_234338_((ResourceLocation)resourceLocation);
                }
            };
        }
    };

    public ShimmerCompat() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::reloadShimmer);
        HammerLib.LOG.info("Enabling Shimmer compatibility module.");
    }

    public static Set<IGlowingBlock> getColoredBlocks() {
        if (BLOCKS != null) {
            return BLOCKS;
        }
        BLOCKS = new HashSet<IGlowingBlock>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof IGlowingBlock)) continue;
            IGlowingBlock i = (IGlowingBlock)block;
            BLOCKS.add(i);
        }
        BLOCKS = Set.copyOf(BLOCKS);
        return BLOCKS;
    }

    public static Set<IGlowingItem> getColoredItems() {
        if (ITEMS != null) {
            return ITEMS;
        }
        ITEMS = new HashSet<IGlowingItem>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof IGlowingItem)) continue;
            IGlowingItem i = (IGlowingItem)item;
            ITEMS.add(i);
        }
        ITEMS = Set.copyOf(ITEMS);
        return ITEMS;
    }

    private ColorPointLight.Template fromPP(ColoredLight src) {
        if (src == null) {
            return null;
        }
        return new ColorPointLight.Template(src.radius, src.r, src.g, src.b, src.a);
    }

    private void reloadShimmer(ForgeShimmerReloadEvent e) {
        if (e.event.getReloadType() == ShimmerReloadEvent.ReloadType.COLORED_LIGHT) {
            for (IGlowingBlock block : ShimmerCompat.getColoredBlocks()) {
                LightManager.INSTANCE.registerBlockLight((Block)Cast.cast(block), (state, pos) -> {
                    Player player = HammerLib.PROXY.getClientPlayer();
                    if (player == null) {
                        return null;
                    }
                    return this.fromPP(block.produceColoredLight(player.m_9236_(), (BlockPos)pos, (BlockState)state, 1.0f));
                });
            }
            for (IGlowingItem item : ShimmerCompat.getColoredItems()) {
                LightManager.INSTANCE.registerItemLight((Item)Cast.cast(item), stack -> {
                    Player player = HammerLib.PROXY.getClientPlayer();
                    if (player == null) {
                        return null;
                    }
                    return this.fromPP(item.produceColoredLight((Entity)player, (ItemStack)stack));
                });
            }
        }
    }

    @Override
    public <R> Optional<R> getAbility(Ability<R> ability) {
        return ability.findIn(this.bloom);
    }
}

