/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;

public class GuiTextObject
extends GuiObject {
    protected Font font;
    protected FormattedCharSequence text;
    public int color;
    public boolean shadow;

    public GuiTextObject(String name, Font font, FormattedCharSequence text, int color, boolean shadow) {
        super(name);
        this.font = font;
        this.text = text;
        this.color = color;
        this.shadow = shadow;
        this.updateDimensions();
    }

    public GuiTextObject setColor(int color) {
        this.color = color;
        return this;
    }

    public GuiTextObject setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextObject setFont(Font font) {
        this.font = font;
        this.updateDimensions();
        return this;
    }

    public GuiTextObject setText(Component text) {
        return this.setText(text.m_7532_());
    }

    public GuiTextObject setText(FormattedCharSequence text) {
        this.text = text;
        this.updateDimensions();
        return this;
    }

    public void updateDimensions() {
        this.width = this.font.m_92724_(this.text);
        Objects.requireNonNull(this.font);
        this.height = 9.0f;
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        gfx.drawString(this.font, this.text, 0, 0, this.color, this.shadow);
    }

    @Generated
    public Font getFont() {
        return this.font;
    }

    @Generated
    public FormattedCharSequence getText() {
        return this.text;
    }
}

