/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.abstractions.sources.EntitySourceType;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.abstractions.sources.TileSourceType;
import org.zeith.hammerlib.core.RegistriesHL;
import org.zeith.hammerlib.util.java.Cast;

public interface IObjectSource<T> {
    public CompoundTag writeSource();

    public IObjectSourceType getType();

    public Class<T> getBaseType();

    public T get(Level var1);

    default public <R> Optional<R> get(Class<R> base, Level level) {
        return Cast.optionally(this.get(level), base);
    }

    public static Supplier<EntitySourceType.EntitySource> ofEntity(@Nonnull Entity entity) {
        return () -> new EntitySourceType.EntitySource(entity.m_19879_());
    }

    public static Supplier<TileSourceType.TileSource> ofTile(@Nonnull BlockEntity tile) {
        return () -> new TileSourceType.TileSource(tile.m_58899_());
    }

    public static CompoundTag writeSource(IObjectSource<?> src) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Src", (Tag)src.writeSource());
        tag.m_128359_("Type", src.getType().getRegistryKey().toString());
        return tag;
    }

    public static Optional<IObjectSource<?>> readSource(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Optional.empty();
        }
        IObjectSourceType type = (IObjectSourceType)RegistriesHL.animationSources().getValue(new ResourceLocation(tag.m_128461_("Type")));
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.readSource(tag.m_128469_("Src")));
    }
}

