/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.client;

import cofh.core.client.CoreRenderType;
import cofh.lib.util.helpers.BlockHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="thermal")
public class DebugRenderer {
    private static final AABB smolBox = new AABB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    private static final RenderType laserBox = RenderType.m_173215_((String)"td:laser", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173104_).m_110685_(RenderType.f_110139_).m_173290_(RenderType.f_110147_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110153_).m_110691_(false));
    private static final RenderType laserLine = RenderType.m_173215_((String)"td:laser", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173095_).m_110673_(CoreRenderType.THICK_LINES).m_110669_(RenderType.f_110119_).m_110685_(RenderType.f_110139_).m_173290_(RenderType.f_110147_).m_110663_(RenderStateShard.f_110111_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110153_).m_110687_(RenderStateShard.f_110114_).m_110691_(false));
    private static final MultiBufferSource.BufferSource BUFFERS = MultiBufferSource.m_109900_((Map)((Map)Util.m_137469_(new HashMap(), map -> {
        map.put(laserBox, new BufferBuilder(laserBox.m_110507_()));
        map.put(laserLine, new BufferBuilder(laserLine.m_110507_()));
    })), (BufferBuilder)new BufferBuilder(256));
    public static Map<UUID, Map<BlockPos, List<BlockPos>>> grids = new HashMap<UUID, Map<BlockPos, List<BlockPos>>>();

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(DebugRenderer::renderWorldLast);
    }

    private static void renderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack pStack = event.getPoseStack();
        pStack.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        pStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        Random random = new Random();
        for (Map.Entry<UUID, Map<BlockPos, List<BlockPos>>> gridEntry : grids.entrySet()) {
            UUID uuid = gridEntry.getKey();
            random.setSeed(uuid.getLeastSignificantBits() ^ uuid.getMostSignificantBits());
            float r = random.nextFloat();
            float g = random.nextFloat();
            float b = random.nextFloat();
            for (Map.Entry<BlockPos, List<BlockPos>> entry : gridEntry.getValue().entrySet()) {
                BlockPos pos = entry.getKey();
                VertexConsumer builder = BUFFERS.m_6299_(laserBox);
                pStack.m_85836_();
                pStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                DebugRenderer.bufferCuboidSolid(builder, pStack.m_85850_().m_252922_(), smolBox, r, g, b, 0.25f);
                pStack.m_85849_();
                RenderSystem.disableDepthTest();
                VertexConsumer vb = BUFFERS.m_6299_(laserLine);
                for (BlockPos edge : entry.getValue()) {
                    BlockPos offset = edge.m_121996_((Vec3i)pos);
                    Direction side = BlockHelper.getSide((BlockPos)offset);
                    Vector3f sub = new Vector3f();
                    if (side != null) {
                        Vec3i norm = side.m_122436_();
                        sub = new Vector3f((float)norm.m_123341_(), (float)norm.m_123342_(), (float)norm.m_123343_());
                        sub.mul(0.25f);
                    }
                    Vector3f start = new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
                    start.add((Vector3fc)sub);
                    Vector3f end = new Vector3f((float)edge.m_123341_() + 0.5f, (float)edge.m_123342_() + 0.5f, (float)edge.m_123343_() + 0.5f);
                    end.sub((Vector3fc)sub);
                    vb.m_252986_(pStack.m_85850_().m_252922_(), start.x(), start.y(), start.z()).m_85950_(1.0f, 0.0f, 0.0f, 0.25f).m_5752_();
                    vb.m_252986_(pStack.m_85850_().m_252922_(), end.x(), end.y(), end.z()).m_85950_(1.0f, 0.0f, 0.0f, 0.25f).m_5752_();
                }
            }
        }
        BUFFERS.m_109912_(laserLine);
        BUFFERS.m_109912_(laserBox);
        pStack.m_85849_();
    }

    private static void bufferCuboidSolid(VertexConsumer builder, Matrix4f matrix, AABB c, float r, float g, float b, float a) {
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82288_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82290_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82292_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(matrix, (float)c.f_82291_, (float)c.f_82289_, (float)c.f_82293_).m_85950_(r, g, b, a).m_5752_();
    }
}

