/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_ores.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.xstopho.resource_nether_ores.registries.BlockRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;

public class ModelProv
extends BlockStateProvider {
    public ModelProv(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "resource_nether_ores", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createTrivialCube(BlockRegistry.NETHER_COAL_ORE, "coal_ore");
        this.createTrivialCube(BlockRegistry.NETHER_COPPER_ORE, "copper_ore");
        this.createTrivialCube(BlockRegistry.NETHER_IRON_ORE, "iron_ore");
        this.createTrivialCube(BlockRegistry.NETHER_DIAMOND_ORE, "diamond_ore");
        this.createTrivialCube(BlockRegistry.NETHER_EMERALD_ORE, "emerald_ore");
        this.createTrivialCube(BlockRegistry.NETHER_LAPIS_ORE, "lapis_ore");
        this.createTrivialCube(BlockRegistry.NETHER_REDSTONE_ORE, "redstone_ore");
    }

    void createTrivialCube(RegistryObject<Block> block, String textureKey) {
        this.simpleBlockWithItem((Block)block.get(), this.createLayeredNetherOreBlock((String)textureKey).model);
    }

    private ConfiguredModel createLayeredNetherOreBlock(String textureKey) {
        return new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("nether_" + textureKey, this.location("block/simple_cube"))).texture("all", new ResourceLocation("block/netherrack"))).texture("layer0", this.location("block/" + textureKey)));
    }

    private ResourceLocation location(String path) {
        return new ResourceLocation("resource_nether_ores", path);
    }
}

