/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.module.SolidFuelModule;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;

public class MelterBlockEntity
extends NameableBlockEntity
implements ITankBlockEntity.ITankInventoryBlockEntity {
    private static final int TANK_CAPACITY = 2160;
    private static final String TAG_INVENTORY = "inventory";
    private static final MutableComponent NAME = TConstruct.makeTranslation("gui", "melter");
    public static final BlockEntityTicker<MelterBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(level, pos, state);
    protected final FluidTankAnimated tank = new FluidTankAnimated(2160, (MantleBlockEntity)this);
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    private int lastStrength = -1;
    private int tick;
    private final MeltingModuleInventory meltingInventory;
    private final LazyOptional<IItemHandler> inventoryHolder;
    private final SolidFuelModule fuelModule;

    public MelterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends MelterBlockEntity>)((BlockEntityType)TinkerSmeltery.melter.get()), pos, state);
    }

    protected MelterBlockEntity(BlockEntityType<? extends MelterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state, (Component)NAME);
        this.meltingInventory = new MeltingModuleInventory((MantleBlockEntity)this, (IFluidHandler)this.tank, Config.COMMON.melterOreRate, 3);
        this.inventoryHolder = LazyOptional.of(() -> this.meltingInventory);
        this.fuelModule = new SolidFuelModule((MantleBlockEntity)this, pos.m_7495_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player playerEntity) {
        return new MelterContainerMenu(id, inv, this);
    }

    public MeltingModuleInventory getItemHandler() {
        return this.meltingInventory;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.FLUID_STACK, (Object)this.tank.getFluid()).with(ModelProperties.TANK_CAPACITY, (Object)this.tank.getCapacity()).build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankHolder.cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
        this.inventoryHolder.invalidate();
    }

    private boolean isFormed() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)MelterBlock.IN_STRUCTURE) && (Boolean)state.m_61143_((Property)MelterBlock.IN_STRUCTURE) != false;
    }

    private void tick(Level level, BlockPos pos, BlockState state) {
        if (this.isFormed()) {
            switch (this.tick) {
                case 0: {
                    if (this.fuelModule.hasFuel() || !this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 2: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    if ((Boolean)state.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        BlockPos down = pos.m_7495_();
                        BlockState downState = level.m_8055_(down);
                        if (downState.m_204336_(TinkerTags.Blocks.FUEL_TANKS) && downState.m_61138_((Property)ControllerBlock.ACTIVE) && (Boolean)downState.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                            level.m_46597_(down, (BlockState)downState.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        }
                    }
                    if (hasFuel) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature(), this.fuelModule.getRate());
                        this.fuelModule.decreaseFuel(1);
                        break;
                    }
                    this.meltingInventory.coolItems();
                }
            }
        } else if (this.tick == 2) {
            if (this.fuelModule.hasFuel()) {
                this.fuelModule.decreaseFuel(1);
            } else {
                this.meltingInventory.coolItems();
            }
        }
        this.tick = (this.tick + 1) % 4;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.fuelModule.readFromTag(tag);
        if (tag.m_128425_(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromTag(tag.m_128469_(TAG_INVENTORY));
        }
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128365_(TAG_INVENTORY, (Tag)this.meltingInventory.writeToTag());
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fuelModule.writeToTag(tag);
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public SolidFuelModule getFuelModule() {
        return this.fuelModule;
    }
}

