/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class PartSwapCastingRecipe
extends AbstractMaterialCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    public static final RecordLoadable<PartSwapCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)IngredientLoadable.ALLOW_EMPTY.requiredField("tools", AbstractCastingRecipe::getCast), (RecordField)ITEM_COST_FIELD, (RecordField)IntLoadable.FROM_ZERO.requiredField("index", r -> r.index), PartSwapCastingRecipe::new);
    private final int index;
    @Nullable
    private MaterialFluidRecipe cachedPartSwapping = null;
    protected List<IDisplayableCastingRecipe> multiRecipes;

    protected PartSwapCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, int index) {
        super(serializer, id, group, cast, itemCost, true, false);
        this.index = index;
    }

    private int getIndex(List<MaterialStatsId> requirements) {
        if (this.index < 0) {
            return requirements.size() + this.index;
        }
        return this.index;
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        MaterialFluidRecipe materialFluidRecipe;
        Item item = inv.getStack().m_41720_();
        if (item instanceof IModifiable) {
            IModifiable modifiable = (IModifiable)item;
            materialFluidRecipe = this.getFluidRecipe(inv, modifiable);
        } else {
            materialFluidRecipe = MaterialFluidRecipe.EMPTY;
        }
        return materialFluidRecipe;
    }

    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv, IModifiable modifiable) {
        ItemStack stack = inv.getStack();
        Fluid fluid = inv.getFluid();
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(modifiable.getToolDefinition());
        int index = this.getIndex(requirements);
        MaterialVariantId currentMaterial = MaterialIdNBT.from(stack).getMaterial(index);
        if (this.cachedPartSwapping != null && this.cachedPartSwapping.matches(fluid, currentMaterial)) {
            return this.cachedPartSwapping;
        }
        MaterialFluidRecipe casting = super.getFluidRecipe(inv);
        if (casting != MaterialFluidRecipe.EMPTY && !casting.getOutput().sameVariant(currentMaterial) && requirements.get(index).canUseMaterial(casting.getOutput().getId())) {
            this.cachedPartSwapping = casting;
            return casting;
        }
        MaterialFluidRecipe composite = MaterialCastingLookup.getCompositeFluid(fluid, currentMaterial);
        if (composite != MaterialFluidRecipe.EMPTY) {
            this.cachedPartSwapping = composite;
            return composite;
        }
        return MaterialFluidRecipe.EMPTY;
    }

    protected boolean canPartSwap(ICastingContainer inv) {
        ItemStack cast = inv.getStack();
        Item item = cast.m_41720_();
        if (!(item instanceof IModifiable)) {
            return false;
        }
        IModifiable modifiable = (IModifiable)item;
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(modifiable.getToolDefinition());
        int index = this.getIndex(requirements);
        if (index >= requirements.size()) {
            return false;
        }
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv, modifiable);
        MaterialVariant output = recipe.getOutput();
        if (recipe == MaterialFluidRecipe.EMPTY || !requirements.get(index).canUseMaterial(output.getId())) {
            return false;
        }
        ToolStack original = ToolStack.from(cast);
        ToolStack tool = original.copy();
        tool.replaceMaterial(index, output);
        return tool.tryValidate() == null && ModifierRemovalHook.onRemoved(original, tool) == null;
    }

    public boolean matches(ICastingContainer inv, Level level) {
        return this.getCast().test(inv.getStack()) && this.canPartSwap(inv);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getCast().m_43908_()[0].m_41777_();
    }

    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        float repairDurability;
        MaterialFluidRecipe fluidRecipe = this.getFluidRecipe(inv);
        MaterialVariant material = fluidRecipe.getOutput();
        ItemStack cast = inv.getStack();
        ToolStack original = ToolStack.from(cast);
        ToolStack tool = original.copy();
        List<MaterialStatsId> stats = ToolMaterialHook.stats(tool.getDefinition());
        int index = this.getIndex(stats);
        tool.replaceMaterial(index, material);
        if (fluidRecipe.getInput() == null && (repairDurability = (float)MaterialRepairModule.getDurability(null, material.getId(), stats.get(index))) > 0.0f && tool.getDamage() > 0) {
            ModifierEntry entry;
            repairDurability *= (float)this.itemCost / 3.0f;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairDurability)) <= 0.0f)) {
            }
            if (repairDurability > 0.0f) {
                ToolDamageUtil.repair(tool, (int)repairDurability);
            }
        }
        tool.tryValidate();
        ModifierRemovalHook.onRemoved(original, tool);
        return tool.copyStack(cast, 1);
    }

    protected static int getFluidAmount(List<FluidStack> fluids) {
        return fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
    }

    private ItemStack withMaterial(ToolStack tool, MaterialVariant material) {
        if (tool.getMaterials().isEmpty()) {
            MaterialNBT.Builder builder = MaterialNBT.builder();
            List<MaterialStatsId> requirements = ToolMaterialHook.stats(tool.getDefinition());
            for (int i = 0; i < requirements.size(); ++i) {
                if (i == this.index) {
                    builder.add(material);
                    continue;
                }
                builder.add(MaterialRegistry.firstWithStatType(requirements.get(i)));
            }
            tool.setMaterials(builder.build());
        } else {
            tool.replaceMaterial(this.index, material);
        }
        return tool.createStack();
    }

    public List<IDisplayableCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            List<ItemStack> casts = List.of(this.getCast().m_43908_());
            this.multiRecipes = Stream.concat(MaterialCastingLookup.getAllCastingFluids().stream().filter(MaterialFluidRecipe::isVisible).flatMap(recipe -> {
                MaterialVariant output = recipe.getOutput();
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(casts.size());
                ArrayList<ItemStack> results = new ArrayList<ItemStack>(casts.size());
                for (ItemStack cast : casts) {
                    ToolStack tool = ToolStack.copyFrom(cast);
                    List<MaterialStatsId> requirements = ToolMaterialHook.stats(tool.getDefinition());
                    if (this.index >= requirements.size() || !requirements.get(this.index).canUseMaterial(output.getId())) continue;
                    results.add(this.withMaterial(tool, output).m_41777_());
                    ItemStack input = this.withMaterial(tool, MaterialVariant.of(ToolBuildHandler.getRenderMaterial(0)));
                    input.m_41784_().m_128379_("tic_display", true);
                    inputs.add(input);
                }
                if (results.isEmpty()) {
                    return Stream.empty();
                }
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                return Stream.of(new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), List.copyOf(inputs), fluids, List.copyOf(results), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * PartSwapCastingRecipe.getFluidAmount(fluids)), this.isConsumed()));
            }), MaterialCastingLookup.getAllCompositeFluids().stream().filter(MaterialFluidRecipe::isVisible).flatMap(recipe -> {
                MaterialVariant output = recipe.getOutput();
                MaterialVariant input = recipe.getInput();
                assert (input != null);
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(casts.size());
                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(casts.size());
                for (ItemStack cast : casts) {
                    MaterialStatsId requirement;
                    ToolStack tool = ToolStack.copyFrom(cast);
                    List<MaterialStatsId> requirements = ToolMaterialHook.stats(tool.getDefinition());
                    if (this.index >= requirements.size() || !(requirement = requirements.get(this.index)).canUseMaterial(output.getId()) || !requirement.canUseMaterial(input.getId())) continue;
                    inputs.add(this.withMaterial(tool, input).m_41777_());
                    outputs.add(this.withMaterial(tool, output));
                }
                if (inputs.isEmpty() || outputs.isEmpty()) {
                    return Stream.empty();
                }
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                return Stream.of(new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), List.copyOf(inputs), fluids, List.copyOf(outputs), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * PartSwapCastingRecipe.getFluidAmount(fluids)), this.isConsumed()));
            })).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }
}

