/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.vec.Vector3;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemUtils {
    public static boolean isPlayerHolding(LivingEntity entity, Predicate<Item> predicate) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = entity.m_21120_(hand);
            if (stack.m_41619_() || !predicate.test(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerHoldingSomething(Player player) {
        return !player.m_21205_().m_41619_() || !player.m_21206_().m_41619_();
    }

    @Nonnull
    public static ItemStack getHeldStack(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(level, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.m_20334_(level.f_46441_.m_188583_() * 0.05, level.f_46441_.m_188583_() * 0.05 + (double)0.2f, level.f_46441_.m_188583_() * 0.05);
        level.m_7967_((Entity)item);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack, double velocity) {
        double xVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.f_46441_.m_188501_() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + xVelocity, (double)pos.m_123342_() + yVelocity, (double)pos.m_123343_() + zVelocity, stack);
        entityItem.m_32010_(10);
        world.m_7967_((Entity)entityItem);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(Level world, BlockPos pos, Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41613_() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static ItemStack copyStack(@Nonnull ItemStack stack, int quantity) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(quantity);
        return stack;
    }

    public static void ejectItem(Level world, BlockPos pos, @Nonnull ItemStack stack, Direction dir) {
        pos.m_121945_(dir);
        ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        entity.m_20256_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(0.3));
        entity.m_32010_(10);
        world.m_7967_((Entity)entity);
    }

    public static void ejectItems(Level world, BlockPos pos, List<ItemStack> stacks, Direction dir) {
        for (ItemStack stack : stacks) {
            ItemUtils.ejectItem(world, pos, stack, dir);
        }
    }

    public static int compareItemStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        int itemStack2ID;
        int itemStack1ID = Item.m_41393_((Item)stack1.m_41720_());
        return itemStack1ID != (itemStack2ID = Item.m_41393_((Item)stack2.m_41720_())) ? itemStack1ID - itemStack2ID : (stack1.m_41773_() == stack2.m_41773_() ? 0 : stack1.m_41773_() - stack2.m_41773_());
    }

    public static boolean areStacksSameType(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return !stack1.m_41619_() && !stack2.m_41619_() && stack1.m_41720_() == stack2.m_41720_() && stack2.m_41773_() == stack1.m_41773_() && ItemStack.m_150942_((ItemStack)stack2, (ItemStack)stack1);
    }
}

