/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="codechickenlib")
public class HighlightHandler {
    private static final Cuboid6 BOX = Cuboid6.full.copy().expand(0.02);
    private static final float[] RED = EnumColour.RED.getColour(128).packArray();
    @Nullable
    public static BlockPos highlight;
    public static boolean useDepth;
    private static final RenderType box;
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH;
    private static final RenderType boxNoDepth;

    @SubscribeEvent
    public static void renderLevelLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (highlight != null) {
            MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 cameraPos = camera.m_90583_();
            PoseStack pStack = event.getPoseStack();
            pStack.m_85836_();
            pStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            pStack.m_252880_((float)highlight.m_123341_(), (float)highlight.m_123342_(), (float)highlight.m_123343_());
            RenderUtils.bufferCuboidSolid(new TransformingVertexConsumer(source.m_6299_(useDepth ? box : boxNoDepth), pStack), BOX, RED[0], RED[1], RED[2], RED[3]);
            source.m_109911_();
            pStack.m_85849_();
        }
    }

    static {
        useDepth = true;
        box = RenderType.m_173215_((String)"ccl:box_depth", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110685_(RenderStateShard.f_110139_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

            public void m_110185_() {
                RenderSystem.disableDepthTest();
            }
        };
        boxNoDepth = RenderType.m_173215_((String)"ccl:box_no_depth", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110685_(RenderStateShard.f_110139_).m_110687_(RenderStateShard.f_110115_).m_110663_(DISABLE_DEPTH).m_110691_(false));
    }
}

