/*
 * Decompiled with CFR 0.152.
 */
package cofh.rightclickgetcrops;

import cofh.lib.api.block.IHarvestable;
import cofh.rightclickgetcrops.RCGCConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="right_click_get_crops")
public class RCGCEvents {
    private static boolean harvestSupport = false;

    public static void init() {
        try {
            Class.forName("cofh.lib.api.block.IHarvestable", false, RCGCEvents.class.getClassLoader());
            harvestSupport = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        IHarvestable harvestable;
        Level world = event.getLevel();
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (RCGCConfig.allowList.get().booleanValue() != ((List)RCGCConfig.cropList.get()).contains(ForgeRegistries.BLOCKS.getKey((Object)block).toString())) {
            return;
        }
        Player player = event.getEntity();
        boolean replant = RCGCConfig.replant.get();
        if (harvestSupport && block instanceof IHarvestable && (harvestable = (IHarvestable)block).canHarvest(state)) {
            harvestable.harvest(world, pos, state, player, replant);
            player.m_6674_(InteractionHand.MAIN_HAND);
            event.setCanceled(true);
            return;
        }
        boolean seedDrop = false;
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockPos below = pos.m_7495_();
            BlockState belowState = world.m_8055_(below);
            replant &= belowState.m_60734_().canSustainPlant(belowState, (BlockGetter)world, below, Direction.UP, (IPlantable)crop);
            if (crop.m_52307_(state)) {
                if (!world.f_46443_) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                    Item seedItem = crop.m_7397_((BlockGetter)world, pos, state).m_41720_();
                    for (ItemStack drop : drops) {
                        if (replant && !seedDrop && drop.m_41720_() == seedItem) {
                            drop.m_41774_(1);
                            seedDrop = true;
                        }
                        if (drop.m_41619_()) continue;
                        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
                    }
                    world.m_46953_(pos, false, (Entity)player);
                    if (seedDrop) {
                        world.m_7731_(pos, crop.m_52289_(0), 3);
                    }
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
            }
        } else if (block instanceof NetherWartBlock) {
            NetherWartBlock crop = (NetherWartBlock)block;
            BlockPos below = pos.m_7495_();
            BlockState belowState = world.m_8055_(below);
            replant &= belowState.m_60734_().canSustainPlant(belowState, (BlockGetter)world, below, Direction.UP, (IPlantable)crop);
            if ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3) {
                if (!world.f_46443_) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                    Item seedItem = crop.m_7397_((BlockGetter)world, pos, state).m_41720_();
                    for (ItemStack drop : drops) {
                        if (replant && !seedDrop && drop.m_41720_() == seedItem) {
                            drop.m_41774_(1);
                            seedDrop = true;
                        }
                        if (drop.m_41619_()) continue;
                        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
                    }
                    world.m_46953_(pos, false, (Entity)player);
                    if (seedDrop) {
                        world.m_7731_(pos, crop.m_49966_(), 3);
                    }
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
            }
        } else if (block instanceof CocoaBlock) {
            CocoaBlock crop = (CocoaBlock)block;
            replant &= crop.m_7898_(state, (LevelReader)world, pos);
            if ((Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2) {
                if (!world.f_46443_) {
                    Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                    Item seedItem = crop.getCloneItemStack(state, (HitResult)event.getHitVec(), (BlockGetter)world, pos, player).m_41720_();
                    for (ItemStack drop : drops) {
                        if (replant && !seedDrop && drop.m_41720_() == seedItem) {
                            drop.m_41774_(1);
                            seedDrop = true;
                        }
                        if (drop.m_41619_()) continue;
                        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)drop);
                    }
                    world.m_46953_(pos, false, (Entity)player);
                    if (seedDrop) {
                        world.m_7731_(pos, (BlockState)crop.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing), 3);
                    }
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
            }
        }
    }
}

