/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;

public class DefaultCapabilityProvider<T>
implements ICapabilityProvider {
    protected final ICapabilityTypeGetter<T> capabilityGetter;
    protected final LazyOptional<T> capability;

    public DefaultCapabilityProvider(ICapabilityTypeGetter<T> capabilityGetter, LazyOptional<T> capability) {
        this.capabilityGetter = Objects.requireNonNull(capabilityGetter);
        this.capability = Objects.requireNonNull(capability);
    }

    public DefaultCapabilityProvider(ICapabilityTypeGetter<T> capabilityGetter, T capability) {
        this((ICapabilityTypeGetter<LazyOptional>)capabilityGetter, LazyOptional.of(() -> Objects.requireNonNull(capability)));
    }

    @Deprecated
    public DefaultCapabilityProvider(Capability<T> capabilityType, T capability) {
        Objects.requireNonNull(capabilityType, "The given capability can not be null, this is probably being called too early during init");
        this.capabilityGetter = () -> capabilityType;
        this.capability = LazyOptional.of(() -> Objects.requireNonNull(capability));
    }

    public Capability<T> getCapabilityType() {
        return Objects.requireNonNull(this.capabilityGetter.getCapability(), "A registered capability is null");
    }

    public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, Direction facing) {
        if (this.getCapabilityType() == Objects.requireNonNull(capability, "A given capability is null")) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }
}

