/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.client.render.model.FacadeModel;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends Item
implements IDynamicModelElement {
    public ItemFacade(Item.Properties properties) {
        super(properties);
    }

    public BlockState getFacadeBlock(ItemStack itemStack) {
        if (!itemStack.m_41619_() && itemStack.m_41782_()) {
            CompoundTag tag = itemStack.m_41783_();
            return BlockHelpers.deserializeBlockState((HolderGetter)BlockHelpers.HOLDER_GETTER_FORGE, (CompoundTag)tag.m_128469_("block"));
        }
        return null;
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        BlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, BlockState blockState) {
        CompoundTag tag = itemStack.m_41784_();
        CompoundTag serializedBlockState = BlockHelpers.serializeBlockState((BlockState)blockState);
        tag.m_128365_("block", (Tag)serializedBlockState);
    }

    public Component m_7626_(ItemStack itemStack) {
        MutableComponent suffix = Component.m_237115_((String)"general.integrateddynamics.info.none").m_130940_(ChatFormatting.ITALIC);
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).m_41786_();
        }
        return ((MutableComponent)super.m_7626_(itemStack)).m_130946_(" - ").m_7220_((Component)suffix);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (!context.m_43725_().m_5776_()) {
            IFacadeable facadeable = (IFacadeable)BlockEntityHelpers.getCapability((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_(), null, FacadeableConfig.CAPABILITY).orElse(null);
            BlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeable != null && blockState != null && !facadeable.hasFacade()) {
                facadeable.setFacade(blockState);
                ItemBlockCable.playPlaceSound(context.m_43725_(), context.m_8083_());
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel createDynamicModel(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation location = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)this), "inventory");
        FacadeModel.emptyModel = (BakedModel)event.getModels().get(location);
        return new FacadeModel();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Color
    implements ItemColor {
        public int m_92671_(ItemStack itemStack, int color) {
            BlockState blockstate = ((ItemFacade)itemStack.m_41720_()).getFacadeBlock(itemStack);
            return Minecraft.m_91087_().m_91298_().m_92577_(blockstate, null, null, color);
        }
    }
}

