/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class IngredientsValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Optional ingredientsOptional = ((ValueObjectTypeIngredients.ValueIngredients)value).getRawValue();
        if (ingredientsOptional.isPresent()) {
            IMixedIngredients ingredients = (IMixedIngredients)ingredientsOptional.get();
            ArrayList values = Lists.newArrayList();
            for (IngredientComponent component : ingredients.getComponents()) {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (Object instance : ingredients.getInstances(component)) {
                    values.add(componentHandler.toValue(instance));
                }
            }
            IngredientsValueTypeWorldRenderer.renderGrid(context, partContainer, direction, partType, values, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
        }
    }

    public static void renderGrid(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, List<IValue> values, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        matrixStack.m_85836_();
        int matrixRadius = IngredientsValueTypeWorldRenderer.getSmallestSquareFrom(values.size());
        float scale = 1.0f / (float)matrixRadius;
        matrixStack.m_85841_(scale, scale, 1.0f);
        for (int i = 0; i < matrixRadius; ++i) {
            int realIndex;
            for (int j = 0; j < matrixRadius && (realIndex = i * matrixRadius + j) < values.size(); ++j) {
                IValue renderValue = values.get(realIndex);
                if (renderValue == null) continue;
                matrixStack.m_85836_();
                matrixStack.m_252880_((float)j * 12.5f, (float)i * 12.5f, 0.0f);
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(renderValue.getType());
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(context, partContainer, direction, partType, renderValue, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
    }

    @Nullable
    protected static <T> T prepareElementForTick(List<T> elements, int tick, Supplier<T> defaultFactory) {
        return (T)(elements.size() > 0 ? elements.get(tick % elements.size()) : defaultFactory.get());
    }

    protected static int getSmallestSquareFrom(int n) {
        while (!IngredientsValueTypeWorldRenderer.isInt(Math.sqrt(n))) {
            ++n;
        }
        return (int)Math.sqrt(n);
    }

    protected static final boolean isInt(double n) {
        return n == Math.floor(n) && !Double.isInfinite(n);
    }
}

