/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.config;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.UtilDefinition;
import dev.schmarrn.lighty.api.LightyColors;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.resources.ResourceLocation;

public class Config {
    private static final String PATH = UtilDefinition.INSTANCE.getConfigDir().toString() + "/lighty.config";
    private final Properties properties = new Properties();
    private static Config config;
    private static final String LAST_USED_MODE = "lighty.last_used_mode";
    private static final String SKY_THRESHOLD = "lighty.sky_threshold";
    private static final String BLOCK_THRESHOLD = "lighty.block_threshold";
    private static final String OVERLAY_DISTANCE = "lighty.overlay_distance";
    private static final String OVERLAY_BRIGHTNESS = "lighty.overlay_brightness";
    private static final String SHOW_SAFE = "lighty.show_safe";
    private static final String OVERLAY_GREEN = "lighty.overlay_green";
    private static final String OVERLAY_ORANGE = "lighty.overlay_orange";
    private static final String OVERLAY_RED = "lighty.overlay_red";

    private Config() {
        try (FileReader reader = new FileReader(PATH);){
            this.properties.load(reader);
            this.properties.putIfAbsent(LAST_USED_MODE, "lighty:carpet_mode");
            this.properties.putIfAbsent(SKY_THRESHOLD, "0");
            this.properties.putIfAbsent(BLOCK_THRESHOLD, "0");
            this.properties.putIfAbsent(OVERLAY_DISTANCE, "2");
            this.properties.putIfAbsent(OVERLAY_BRIGHTNESS, "10");
            this.properties.putIfAbsent(SHOW_SAFE, String.valueOf(true));
            this.properties.putIfAbsent(OVERLAY_GREEN, Integer.toHexString(65280));
            this.properties.putIfAbsent(OVERLAY_ORANGE, Integer.toHexString(0xFF6600));
            this.properties.putIfAbsent(OVERLAY_RED, Integer.toHexString(0xFF0000));
        }
        catch (FileNotFoundException e) {
            Lighty.LOGGER.warn("No Lighty config found at {}, loading defaults and saving config file.", (Object)PATH);
            this.properties.setProperty(LAST_USED_MODE, "lighty:carpet_mode");
            this.properties.setProperty(SKY_THRESHOLD, "0");
            this.properties.setProperty(BLOCK_THRESHOLD, "0");
            this.properties.setProperty(OVERLAY_DISTANCE, "2");
            this.properties.setProperty(OVERLAY_BRIGHTNESS, "10");
            this.properties.setProperty(SHOW_SAFE, String.valueOf(true));
            this.properties.setProperty(OVERLAY_GREEN, Integer.toHexString(65280));
            this.properties.setProperty(OVERLAY_ORANGE, Integer.toHexString(0xFF6600));
            this.properties.setProperty(OVERLAY_RED, Integer.toHexString(0xFF0000));
        }
        catch (IOException e) {
            Lighty.LOGGER.error("Error while reading from Lighty config at {}: {}", (Object)PATH, (Object)e);
        }
        this.write();
    }

    private void write() {
        try (FileWriter writer = new FileWriter(PATH);){
            this.properties.store(writer, null);
        }
        catch (IOException e) {
            Lighty.LOGGER.error("Error while writing to Lighty config at {}: {}", (Object)PATH, (Object)e);
        }
    }

    public static int getSkyThreshold() {
        return Integer.parseInt(Config.config.properties.getProperty(SKY_THRESHOLD, "0"));
    }

    public static int getBlockThreshold() {
        return Integer.parseInt(Config.config.properties.getProperty(BLOCK_THRESHOLD, "0"));
    }

    public static int getOverlayDistance() {
        return Integer.parseInt(Config.config.properties.getProperty(OVERLAY_DISTANCE, "2"));
    }

    public static int getOverlayBrightness() {
        return Integer.parseInt(Config.config.properties.getProperty(OVERLAY_BRIGHTNESS, "10"));
    }

    public static boolean getShowSafe() {
        return Boolean.parseBoolean(Config.config.properties.getProperty(SHOW_SAFE, String.valueOf(true)));
    }

    public static ResourceLocation getLastUsedMode() {
        return new ResourceLocation(Config.config.properties.getProperty(LAST_USED_MODE, "lighty:carpet_mode"));
    }

    public static void setLastUsedMode(ResourceLocation id) {
        Config.config.properties.setProperty(LAST_USED_MODE, id.toString());
        config.write();
    }

    public static void setSkyThreshold(int i) {
        Config.config.properties.setProperty(SKY_THRESHOLD, String.valueOf(i));
        config.write();
    }

    public static void setBlockThreshold(int i) {
        Config.config.properties.setProperty(BLOCK_THRESHOLD, String.valueOf(i));
        config.write();
    }

    public static void setOverlayDistance(int i) {
        Config.config.properties.setProperty(OVERLAY_DISTANCE, String.valueOf(i));
        config.write();
    }

    public static void setOverlayBrightness(int i) {
        Config.config.properties.setProperty(OVERLAY_BRIGHTNESS, String.valueOf(i));
        config.write();
    }

    public static void setShowSafe(boolean b) {
        Config.config.properties.setProperty(SHOW_SAFE, String.valueOf(b));
        config.write();
    }

    public static void setOverlayGreen(int color) {
        Config.config.properties.setProperty(OVERLAY_GREEN, Integer.toHexString(color));
        config.write();
        LightyColors.onConfigUpdate();
    }

    public static void setOverlayOrange(int color) {
        Config.config.properties.setProperty(OVERLAY_ORANGE, Integer.toHexString(color));
        config.write();
        LightyColors.onConfigUpdate();
    }

    public static void setOverlayRed(int color) {
        Config.config.properties.setProperty(OVERLAY_RED, Integer.toHexString(color));
        config.write();
        LightyColors.onConfigUpdate();
    }

    public static int getOverlayGreen() {
        return Integer.parseUnsignedInt(Config.config.properties.getProperty(OVERLAY_GREEN, Integer.toHexString(65280)), 16);
    }

    public static int getOverlayOrange() {
        return Integer.parseUnsignedInt(Config.config.properties.getProperty(OVERLAY_ORANGE, Integer.toHexString(0xFF6600)), 16);
    }

    public static int getOverlayRed() {
        return Integer.parseUnsignedInt(Config.config.properties.getProperty(OVERLAY_RED, Integer.toHexString(0xFF0000)), 16);
    }

    public static void init() {
        config = new Config();
    }
}

