/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;

public class PotionHelperCommonCapabilities {
    private static List<IRecipeDefinition> VANILLA_RECIPES = null;

    public static List<IRecipeDefinition> getVanillaRecipes() {
        if (VANILLA_RECIPES == null) {
            VANILLA_RECIPES = Lists.newArrayList();
            ArrayList inputItems = Lists.newArrayList((Object[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)});
            ArrayList ingredients = Lists.newArrayList();
            for (PotionBrewing.Mix mixPredicate : PotionBrewing.f_43495_) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.f_43533_));
            }
            for (PotionBrewing.Mix mixPredicate : PotionBrewing.f_43494_) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.f_43533_));
            }
            ArrayList checkInputItems = Lists.newArrayList((Iterable)inputItems);
            while (!checkInputItems.isEmpty()) {
                ArrayList newItems = Lists.newArrayList();
                for (ItemStack inputItem : checkInputItems) {
                    PrototypedIngredient<ItemStack, Integer> item = new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, inputItem, 5);
                    for (IPrototypedIngredient ingredient : ingredients) {
                        ItemStack output = PotionBrewing.m_43529_((ItemStack)((ItemStack)ingredient.getPrototype()).m_41777_(), (ItemStack)inputItem.m_41777_());
                        if (!PotionHelperCommonCapabilities.isPotionOutputValid(inputItem, output)) continue;
                        PotionHelperCommonCapabilities.addRecipeIfNew(ingredient, item, output, newItems);
                    }
                    if (VANILLA_RECIPES.size() <= 7500) continue;
                    throw new RuntimeException("Infinite loop detected! Please report this to the Common Capabilities issue tracker with a list of (potion-changing) mods installed");
                }
                checkInputItems = newItems;
            }
        }
        return VANILLA_RECIPES;
    }

    protected static boolean isPotionOutputValid(ItemStack input, ItemStack output) {
        return !input.m_41619_() && !output.m_41619_() && (input.m_41720_() != output.m_41720_() || PotionUtils.m_43579_((ItemStack)output) != Potions.f_43599_ && !Objects.equals(ForgeRegistries.POTIONS.getKey((Object)PotionUtils.m_43579_((ItemStack)output)), ForgeRegistries.POTIONS.getKey((Object)PotionUtils.m_43579_((ItemStack)input))));
    }

    protected static void addRecipeIfNew(IPrototypedIngredient<ItemStack, Integer> ingredient, IPrototypedIngredient<ItemStack, Integer> item, ItemStack output, List<ItemStack> newItems) {
        RecipeDefinition recipe = RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new IPrototypedIngredient[]{ingredient}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item})}), MixedIngredients.ofInstances(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{ItemStack.f_41583_, output, output, output})));
        if (!VANILLA_RECIPES.contains(recipe)) {
            VANILLA_RECIPES.add(recipe);
            newItems.add(output);
        }
    }
}

