/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.config;

import it.crystalnest.cobweb.api.config.ConfigType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class CobwebConfig {
    private static final Map<String, Pair<? extends CobwebConfig, ForgeConfigSpec>> CONFIGS = new HashMap<String, Pair<? extends CobwebConfig, ForgeConfigSpec>>();

    protected CobwebConfig(ForgeConfigSpec.Builder builder) {
        this.define(builder);
        builder.build();
    }

    protected static <T extends CobwebConfig> void register(String modId, ConfigType type, Function<ForgeConfigSpec.Builder, T> constructor) {
        CONFIGS.put(CobwebConfig.getId(modId, type), (Pair<? extends CobwebConfig, ForgeConfigSpec>)new ForgeConfigSpec.Builder().configure(constructor));
    }

    @Nullable
    protected static <T extends CobwebConfig> T getConfig(String modId, ConfigType type) {
        return (T)(CONFIGS.containsKey(CobwebConfig.getId(modId, type)) ? (CobwebConfig)CONFIGS.get(CobwebConfig.getId(modId, type)).getLeft() : null);
    }

    @Nullable
    protected static ForgeConfigSpec getSpec(String modId, ConfigType type) {
        return CONFIGS.containsKey(CobwebConfig.getId(modId, type)) ? (ForgeConfigSpec)CONFIGS.get(CobwebConfig.getId(modId, type)).getRight() : null;
    }

    protected static String getId(String modId, ConfigType type) {
        return modId + "_" + type;
    }

    public void register() {
    }

    protected abstract void define(ForgeConfigSpec.Builder var1);

    protected boolean stringListValidator(Object element) {
        String string;
        return element instanceof String && !(string = (String)element).isBlank();
    }
}

