/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;

public class PlayerHelpers {
    private static final Map<ServerLevel, FakePlayer> FAKE_PLAYERS = new WeakHashMap<ServerLevel, FakePlayer>();

    public static FakePlayer getFakePlayer(ServerLevel world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new ExtendedFakePlayer(world);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    public static void setPlayerState(Player player, InteractionHand hand, BlockPos pos, double offsetX, double offsetY, double offsetZ, Direction side, boolean sneaking) {
        player.m_6034_((double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ);
        player.f_19854_ = player.m_20185_();
        player.f_19855_ = player.m_20186_();
        player.f_19856_ = player.m_20189_();
        player.m_146922_(side.m_122424_().m_122435_());
        player.m_146926_(side == Direction.UP ? 90.0f : (side == Direction.DOWN ? -90.0f : 0.0f));
        player.f_19816_ = 0.0f;
        player.m_20260_(sneaking);
        PlayerHelpers.setHeldItemSilent(player, hand, ItemStack.f_41583_);
        player.m_8119_();
        player.m_6853_(true);
    }

    public static void setHeldItemSilent(Player player, InteractionHand hand, ItemStack itemStack) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)itemStack);
        } else if (hand == InteractionHand.OFF_HAND) {
            player.m_150109_().f_35976_.set(0, (Object)itemStack);
        } else {
            player.m_21008_(hand, itemStack);
        }
    }
}

