/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.CokeOvenBlockEntity;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.CookingModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CokeOvenModule
extends CookingModule<CokeOvenRecipe, CokeOvenBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_LIQUID_INPUT = 2;
    public static final int SLOT_LIQUID_PROCESSING = 3;
    public static final int SLOT_LIQUID_OUTPUT = 4;
    private final ContainerMapper outputContainer;
    private int multiplier = 1;
    private final StandardTank tank;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private final ContainerMapper fluidContainer;
    private final LazyOptional<IItemHandler> itemHandler;
    private final LazyOptional<IFluidHandler> fluidHandler;

    public CokeOvenModule(CokeOvenBlockEntity provider) {
        super(provider, 5, 0);
        this.tank = StandardTank.ofBuckets(64).disableFill().changeCallback(this::m_6596_);
        this.outputContainer = ContainerMapper.make(this, 1, 1).ignoreItemChecks();
        this.fluidContainer = ContainerMapper.make(this, 2, 4);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper(this){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0) {
                    return ItemStack.f_41583_;
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        });
        this.fluidHandler = LazyOptional.of(() -> this.tank);
    }

    @Override
    protected RecipeType<CokeOvenRecipe> getRecipeType() {
        return (RecipeType)RailcraftRecipeTypes.COKING.get();
    }

    @Override
    protected boolean craftAndPush() {
        boolean crafted = false;
        for (int i = 0; i < this.multiplier; ++i) {
            crafted |= this.craftAndPushImp();
        }
        return crafted;
    }

    private boolean craftAndPushImp() {
        ItemStack output = ((CokeOvenRecipe)this.recipe).m_8043_(((CokeOvenBlockEntity)this.provider).level().m_9598_());
        FluidStack fluidOutput = ((CokeOvenRecipe)this.recipe).getCreosote();
        if (this.outputContainer.canFit(output) && (fluidOutput.isEmpty() || this.tank.internalFill(fluidOutput, IFluidHandler.FluidAction.SIMULATE) >= fluidOutput.getAmount())) {
            this.m_7407_(0, 1);
            this.outputContainer.insert(output);
            this.tank.internalFill(fluidOutput, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    @Override
    public void serverTick() {
        ItemStack bottomSlot;
        super.serverTick();
        ItemStack topSlot = this.m_8020_(2);
        if (!topSlot.m_41619_() && !FluidTools.isFluidHandler(topSlot)) {
            this.m_6836_(2, ItemStack.f_41583_);
            ((CokeOvenBlockEntity)this.provider).dropItem(topSlot);
        }
        if (!(bottomSlot = this.m_8020_(4)).m_41619_() && !FluidTools.isFluidHandler(bottomSlot)) {
            this.m_6836_(4, ItemStack.f_41583_);
            ((CokeOvenBlockEntity)this.provider).dropItem(bottomSlot);
        }
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.fluidContainer, this.tank, FluidTools.ProcessType.FILL_ONLY, this.processState);
        }
    }

    public boolean needsFuel() {
        return this.m_8020_(0).m_41613_() < 8;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean m_7013_(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                if (!this.getRecipeFor(itemStack).isPresent()) return false;
                break;
            }
            case 2: {
                if (!FluidTools.isRoomInContainer(itemStack, (Fluid)RailcraftFluids.CREOSOTE.get())) return false;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.m_7013_(slot, itemStack)) return false;
        return true;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128359_("processState", this.processState.m_7912_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.processState = FluidTools.ProcessState.fromTag(tag);
    }
}

