/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.worldspike;

import mods.railcraft.Translations;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.worldspike.PersonalWorldSpikeBlockEntity;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.worldspike.WorldSpikeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class PersonalWorldSpikeBlock
extends WorldSpikeBlock {
    public PersonalWorldSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PersonalWorldSpikeBlockEntity) {
            PersonalWorldSpikeBlockEntity worldSpike = (PersonalWorldSpikeBlockEntity)blockEntity;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                worldSpike.setOwner(player.m_36316_());
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        PersonalWorldSpikeBlockEntity worldSpike;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PersonalWorldSpikeBlockEntity && ((worldSpike = (PersonalWorldSpikeBlockEntity)blockEntity).getOwner().isEmpty() || worldSpike.isOwnerOrOperator(player.m_36316_()))) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return false;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PersonalWorldSpikeBlockEntity(blockPos, blockState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : PersonalWorldSpikeBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.PERSONAL_WORLD_SPIKE.get()), WorldSpikeBlockEntity::serverTick);
    }

    @Override
    public Component jeiDescription() {
        return Component.m_237115_((String)Translations.Jei.PERSONAL_WORLD_SPIKE);
    }
}

