/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.OutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class DetectorTrackBlock
extends OutfittedTrackBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<Mode> MODE = EnumProperty.m_61587_((String)"mode", Mode.class);

    public DetectorTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)super.buildDefaultState(blockState).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)Mode.BI_DIRECTIONAL));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED, MODE});
    }

    @Override
    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        ((Mode)((Object)blockState.m_61143_(MODE))).updatePowerState(blockState, (Level)level, blockPos);
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos blockPos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, blockPos, cart);
        ((Mode)((Object)blockState.m_61143_(MODE))).updatePowerState(blockState, level, blockPos);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        Mode mode = (Mode)((Object)blockState.m_61143_(MODE));
        Mode newMode = player.m_6047_() ? mode.previous() : mode.next();
        return level.m_46597_(blockPos, (BlockState)blockState.m_61124_(MODE, (Comparable)((Object)newMode)));
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos blockPos, Direction direction) {
        return this.m_6378_(state, level, blockPos, direction);
    }

    public boolean m_7278_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)POWERED);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        if (this.m_7278_(blockState)) {
            List<AbstractMinecart> carts = EntitySearcher.findMinecarts().at(pos).upTo(-0.2f).list(level);
            if (!carts.isEmpty() && carts.get(0).getComparatorLevel() > -1) {
                return carts.get(0).getComparatorLevel();
            }
            List<MinecartCommandBlock> commandCarts = EntitySearcher.find(MinecartCommandBlock.class).at(pos).upTo(-0.2f).list(level);
            if (!commandCarts.isEmpty()) {
                return commandCarts.get(0).m_38534_().m_45436_();
            }
            List<AbstractMinecart> chestCarts = EntitySearcher.findMinecarts().at(pos).upTo(-0.2f).and(EntitySelector.f_20405_).list(level);
            if (!chestCarts.isEmpty()) {
                return AbstractContainerMenu.m_38938_((Container)((Container)chestCarts.get(0)));
            }
        }
        return 0;
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.DETECTOR_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_DETECTION_DIRECTION).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.COMPARATOR_OUTPUT_FROM_CARTS).m_130940_(ChatFormatting.RED));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode implements StringRepresentable
    {
        BI_DIRECTIONAL("bi_directional"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                Mode.setTrackPowering(blockState, level, blockPos, !Mode.findCarts(level, blockPos).isEmpty());
            }
        }
        ,
        TRAVEL("travel"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                2.updatePowerState(blockState, level, blockPos, false);
            }
        }
        ,
        TRAVEL_REVERSED("travel_reversed"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                3.updatePowerState(blockState, level, blockPos, true);
            }
        };

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        protected static void updatePowerState(BlockState blockState, Level level, BlockPos blockPos, boolean reversed) {
            List<AbstractMinecart> carts = Mode.findCarts(level, blockPos);
            if (carts.isEmpty()) {
                Mode.setTrackPowering(blockState, level, blockPos, false);
                return;
            }
            RailShape shape = TrackBlock.getRailShapeRaw(blockState);
            Predicate<AbstractMinecart> travelling = RailShapeUtil.isEastWest(shape) ? cart -> reversed ? cart.m_20184_().m_7096_() < 0.0 : cart.m_20184_().m_7096_() > 0.0 : cart -> reversed ? cart.m_20184_().m_7094_() > 0.0 : cart.m_20184_().m_7094_() < 0.0;
            Mode.setTrackPowering(blockState, level, blockPos, carts.stream().anyMatch(travelling));
        }

        private static void setTrackPowering(BlockState blockState, Level level, BlockPos blockPos, boolean powered) {
            if (powered) {
                level.m_186460_(blockPos, blockState.m_60734_(), 10);
            }
            if (powered != (Boolean)blockState.m_61143_((Property)POWERED)) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
                level.m_46672_(blockPos, blockState.m_60734_());
                level.m_46672_(blockPos.m_121945_(Direction.DOWN), blockState.m_60734_());
            }
        }

        private static List<AbstractMinecart> findCarts(Level level, BlockPos blockPos) {
            return EntitySearcher.findMinecarts().at(blockPos).upTo(-0.2f).list(level);
        }

        public String m_7912_() {
            return this.name;
        }

        private Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        private Mode previous() {
            return (Mode)EnumUtil.previous((Enum)this, (Enum[])Mode.values());
        }

        protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
        }
    }
}

