/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public abstract class ManipulatorBlock<T extends ManipulatorBlockEntity>
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final Class<T> blockEntityType;

    protected ManipulatorBlock(Class<T> blockEntityType, BlockBehaviour.Properties properties) {
        super(properties);
        this.blockEntityType = blockEntityType;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (!this.blockEntityType.isInstance(blockEntity)) {
                return InteractionResult.PASS;
            }
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)((MenuProvider)this.blockEntityType.cast(blockEntity)), (BlockPos)blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public abstract Direction getFacing(BlockState var1);

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        boolean emit = false;
        if (ManipulatorBlock.isPowered(blockState)) {
            BlockState neighborBlockState = level.m_8055_(blockPos.m_121945_(direction.m_122424_()));
            emit = BaseRailBlock.m_49416_((BlockState)neighborBlockState);
        }
        return emit ? 15 : 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && this.blockEntityType.isInstance(blockEntity = level.m_7702_(pos))) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)this.blockEntityType.cast(blockEntity)));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public static boolean isPowered(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)POWERED);
    }
}

