/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.worldspike;

import mods.railcraft.particle.ChunkLoaderParticleOptions;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WorldSpikeBlockEntity
extends RailcraftBlockEntity {
    public WorldSpikeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.WORLD_SPIKE.get(), blockPos, blockState);
    }

    protected WorldSpikeBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, WorldSpikeBlockEntity blockEntity) {
        WorldSpikeBlockEntity.spawnParticle((ServerLevel)level, blockPos);
    }

    public static void spawnParticle(ServerLevel level, BlockPos blockPos) {
        RandomSource random = level.f_46441_;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int x = chunkPos.f_45578_ - 1; x <= chunkPos.f_45578_ + 1; ++x) {
            for (int z = chunkPos.f_45579_ - 1; z <= chunkPos.f_45579_ + 1; ++z) {
                int xCorner = x * 16;
                int zCorner = z * 16;
                double yCorner = blockPos.m_123342_() - 8;
                if (!random.m_188499_()) continue;
                double xParticle = (float)xCorner + random.m_188501_() * 16.0f;
                double yParticle = yCorner + (double)(random.m_188501_() * 16.0f);
                double zParticle = (float)zCorner + random.m_188501_() * 16.0f;
                Vec3 dest = new Vec3((double)blockPos.m_123341_() + 0.1, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.1);
                level.m_8767_((ParticleOptions)new ChunkLoaderParticleOptions(dest), xParticle, yParticle, zParticle, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

