/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.detector.LocomotiveDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LocomotiveDetectorBlockEntity
extends FilterDetectorBlockEntity {
    public LocomotiveDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOCOMOTIVE_DETECTOR.get(), blockPos, blockState, 2);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        ItemStack primary = this.invFilters.m_8020_(0);
        ItemStack secondary = this.invFilters.m_8020_(1);
        for (AbstractMinecart cart : minecarts) {
            if (!(cart instanceof Locomotive)) continue;
            Locomotive locomotive = (Locomotive)cart;
            if (primary.m_41619_() && secondary.m_41619_()) {
                return 15;
            }
            if (DyeColor.getColor((ItemStack)primary) == locomotive.getPrimaryDyeColor() && secondary.m_41619_()) {
                return 15;
            }
            if (DyeColor.getColor((ItemStack)secondary) == locomotive.getSecondaryDyeColor() && primary.m_41619_()) {
                return 15;
            }
            boolean matches = DyeColor.getColor((ItemStack)primary) == locomotive.getPrimaryDyeColor() && DyeColor.getColor((ItemStack)secondary) == locomotive.getSecondaryDyeColor();
            if (!matches) continue;
            return 15;
        }
        return 0;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new LocomotiveDetectorMenu(id, inventory, this);
    }
}

