/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.charge;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.level.block.charge.ChargeBlock;
import mods.railcraft.world.level.block.entity.charge.BatteryBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BatteryBlock
extends ChargeBlock
implements EntityBlock,
JeiSearchable {
    private static final VoxelShape SHAPE = Shapes.m_83064_((AABB)BoxBuilder.create().box().raiseCeiling(-0.0625).build());

    public BatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Charge.distribution.network(serverLevel).access(pos).zap(entity, Charge.DamageOrigin.BLOCK, 1.0f);
        }
    }

    protected abstract ChargeBlock.Spec getChargeSpec();

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return Collections.singletonMap(Charge.distribution, this.getChargeSpec());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BatteryBlockEntity(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.CHARGE_NETWORK_BATTERY).m_130940_(ChatFormatting.BLUE));
        ChargeBlock.Spec spec = this.getChargeSpec();
        boolean isRechargeable = spec.storageSpec().initialState().equals((Object)ChargeStorage.State.RECHARGEABLE);
        int capacity = spec.storageSpec().capacity() / 1000;
        int maxDraw = spec.storageSpec().maxDraw();
        float loss = spec.losses();
        int efficiency = (int)(spec.storageSpec().efficiency() * 100.0f);
        tooltip.add((Component)Component.m_237115_((String)(isRechargeable ? Translations.Tips.TYPE_RECHARGEABLE : Translations.Tips.TYPE_DISPOSABLE)).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)Translations.Tips.CAPACITY, (Object[])new Object[]{capacity}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)Translations.Tips.MAX_DRAW, (Object[])new Object[]{maxDraw}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)Translations.Tips.LOSS, (Object[])new Object[]{Float.valueOf(loss)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)Translations.Tips.EFFICIENCY, (Object[])new Object[]{efficiency}).m_130940_(ChatFormatting.GRAY));
    }
}

