/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.RefinedFirestoneItem;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;

public class RitualBlock
extends BaseEntityBlock {
    public static final BooleanProperty CRACKED = BooleanProperty.m_61465_((String)"cracked");
    private static final VoxelShape SHAPE = Shapes.m_83064_((AABB)BoxBuilder.create().box().inflateHorizontally(-0.3).raiseCeiling(-0.5625).shiftY(0.75).build());

    public RitualBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CRACKED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter blockGetter, BlockPos pos, Player player) {
        return RefinedFirestoneItem.getItemCharged();
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof RitualBlockEntity) {
            RitualBlockEntity firestone = (RitualBlockEntity)blockEntity;
            RefinedFirestoneItem item = (Boolean)state.m_61143_((Property)CRACKED) != false ? (RefinedFirestoneItem)((Object)RailcraftItems.CRACKED_FIRESTONE.get()) : (RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get());
            ItemStack drop = item.m_7968_();
            if (firestone.m_8077_()) {
                drop.m_41714_(firestone.m_7770_());
            }
            drop.m_41721_(drop.m_41776_() - firestone.charge());
            drops.add(drop);
        } else {
            drops.add(RefinedFirestoneItem.getItemEmpty());
        }
        return drops;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine particleEngine) {
                return true;
            }

            public boolean addHitEffects(BlockState state, Level level, HitResult result, ParticleEngine particleEngine) {
                return true;
            }
        });
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new RitualBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return RitualBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.RITUAL.get()), (BlockEntityTicker)(level.m_5776_() ? RitualBlockEntity::clientTick : RitualBlockEntity::serverTick));
    }
}

