/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterBlockEntity;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterState;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ForceTrackEmitterBlock
extends BaseEntityBlock
implements ChargeBlock {
    public static final DyeColor DEFAULT_COLOR = DyeColor.LIGHT_BLUE;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.RECHARGEABLE, 1000, 1000, 1.0f));

    public ForceTrackEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)DEFAULT_COLOR));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, COLOR});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (super.m_6227_(state, level, pos, player, hand, rayTraceResult).m_19077_()) {
            return InteractionResult.CONSUME;
        }
        if (player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ForceTrackEmitterBlockEntity) {
            ForceTrackEmitterBlockEntity t = (ForceTrackEmitterBlockEntity)blockEntity;
            DyeColor color = DyeColor.getColor((ItemStack)heldItem);
            if (color != null && t.setColor(color)) {
                if (!player.m_7500_()) {
                    player.m_21008_(hand, ContainerTools.depleteItem(heldItem));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    private ItemStack getItem(BlockState blockState) {
        ItemStack itemStack = this.m_5456_().m_7968_();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("color", ((DyeColor)blockState.m_61143_(COLOR)).m_41065_());
        return itemStack;
    }

    public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getItem(blockState);
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return Collections.singletonList(this.getItem(blockState));
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)POWERED)).booleanValue()) {
            Charge.zapEffectProvider().throwSparks(stateIn, level, pos, rand, 10);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.registerNode(state, level, pos);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        if (level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).map(ForceTrackEmitterBlockEntity::getStateInstance).map(ForceTrackEmitterState.Instance::state).filter(ForceTrackEmitterState.RETRACTED::equals).isEmpty()) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.m_60713_(oldState.m_60734_())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos changedPos, boolean something) {
        super.m_6861_(state, level, pos, block, changedPos, something);
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::checkSignal);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && (blockEntity = level.m_7702_(pos)) instanceof ForceTrackEmitterBlockEntity) {
            ForceTrackEmitterBlockEntity t = (ForceTrackEmitterBlockEntity)blockEntity;
            DyeColor color = DyeColor.m_41057_((String)tag.m_128461_("color"), null);
            if (color != null) {
                t.setColor(color);
            }
        }
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::checkSignal);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::clearTracks);
        }
        super.m_6810_(state, level, pos, newState, moved);
        if (!state.m_60713_(newState.m_60734_())) {
            this.deregisterNode((ServerLevel)level, pos);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ForceTrackEmitterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : ForceTrackEmitterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()), ForceTrackEmitterBlockEntity::serverTick);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.FORCE_TRACK_EMITTER).m_130940_(ChatFormatting.GRAY));
    }

    public static Direction getFacing(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)FACING);
    }
}

