/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.UUID;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.worldspike.WorldSpikeBlock;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.slf4j.Logger;

public class WorldSpikeMinecart
extends RailcraftMinecart {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ChunkPos lastChunk;
    private final LongOpenHashSet chunkSet = new LongOpenHashSet();

    public WorldSpikeMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public WorldSpikeMinecart(ItemStack itemStack, double x, double y, double z, Level level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.WORLD_SPIKE.get(), x, y, z, level);
    }

    public BlockState m_6390_() {
        return ((WorldSpikeBlock)RailcraftBlocks.WORLD_SPIKE.get()).m_49966_();
    }

    public int m_7144_() {
        return 6;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WorldSpikeBlockEntity.spawnParticle(serverLevel, this.m_20097_());
            if (!this.m_146902_().equals((Object)this.lastChunk)) {
                LongOpenHashSet newChunkSet = new LongOpenHashSet();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x * z != 0) continue;
                        ChunkPos loadChunk = new ChunkPos(this.m_146902_().f_45578_ + x, this.m_146902_().f_45579_ + z);
                        newChunkSet.add(loadChunk.m_45588_());
                        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"railcraft", (UUID)this.f_19820_, (int)loadChunk.f_45578_, (int)loadChunk.f_45579_, (boolean)true, (boolean)false);
                    }
                }
                boolean modified = this.chunkSet.removeAll((LongCollection)newChunkSet);
                if (modified) {
                    LongIterator longIterator = this.chunkSet.iterator();
                    while (longIterator.hasNext()) {
                        long chunkPos = (Long)longIterator.next();
                        int x = (int)chunkPos;
                        int z = (int)(chunkPos >> 32);
                        LOGGER.info("Unload chunk [X: {}, Z: {}]", (Object)x, (Object)z);
                        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"railcraft", (UUID)this.f_19820_, (int)x, (int)z, (boolean)false, (boolean)false);
                    }
                }
                this.chunkSet.clear();
                this.chunkSet.addAll((LongCollection)newChunkSet);
                this.lastChunk = this.m_146902_();
                this.m_6596_();
            }
        }
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.info("Minecart removed");
            level = this.chunkSet.iterator();
            while (level.hasNext()) {
                long chunkPos = (Long)level.next();
                int x = (int)chunkPos;
                int z = (int)(chunkPos >> 32);
                LOGGER.info("Unload chunk [X: {}, Z: {}]", (Object)x, (Object)z);
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"railcraft", (UUID)this.f_19820_, (int)x, (int)z, (boolean)false, (boolean)false);
            }
        }
    }

    public int m_6643_() {
        return 0;
    }

    @Override
    protected boolean hasMenu() {
        return false;
    }

    protected AbstractContainerMenu m_7402_(int i, Inventory inventory) {
        return null;
    }

    @Override
    public Item m_213728_() {
        return (Item)RailcraftItems.WORLD_SPIKE_MINECART.get();
    }
}

