/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public abstract class MaintenanceMinecart
extends RailcraftMinecart {
    private static final EntityDataAccessor<Integer> BLINK = SynchedEntityData.m_135353_(MaintenanceMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final double DRAG_FACTOR = 0.9;
    private static final int BLINK_DURATION = 3;
    private static final EntityDataAccessor<Mode> MODE = SynchedEntityData.m_135353_(MaintenanceMinecart.class, RailcraftDataSerializers.MAINTENANCE_MODE);

    protected MaintenanceMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected MaintenanceMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(itemStack, type, x, y, z, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLINK, (Object)0);
        this.f_19804_.m_135372_(MODE, (Object)Mode.ON);
    }

    public float getMaxCartSpeedOnRail() {
        return this.mode().speed();
    }

    public Mode mode() {
        return (Mode)this.f_19804_.m_135370_(MODE);
    }

    public void setMode(Mode mode) {
        this.f_19804_.m_135381_(MODE, (Object)mode);
    }

    public int m_6643_() {
        return 0;
    }

    protected void blink() {
        this.f_19804_.m_135381_(BLINK, (Object)3);
    }

    protected void setBlink(int blink) {
        this.f_19804_.m_135381_(BLINK, (Object)blink);
    }

    protected int getBlink() {
        return (Integer)this.f_19804_.m_135370_(BLINK);
    }

    public boolean isBlinking() {
        return this.getBlink() > 0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.isBlinking()) {
            this.setBlink(this.getBlink() - 1);
        }
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    protected void m_7114_() {
        super.m_7114_();
        this.m_20256_(this.m_20184_().m_82542_(0.9, 1.0, 0.9));
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("mode", this.mode().m_7912_());
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMode(Mode.fromName(tag.m_128461_("mode")));
    }

    protected boolean placeNewTrack(BlockPos pos, int slotStock, RailShape railShape) {
        ItemStack trackStack = this.m_8020_(slotStock);
        if (!trackStack.m_41619_() && TrackUtil.placeRailAt(trackStack, (ServerLevel)this.m_9236_(), pos, railShape)) {
            this.m_7407_(slotStock, 1);
            this.blink();
            return true;
        }
        return false;
    }

    protected RailShape removeOldTrack(BlockPos pos, BlockState state) {
        List drops = state.m_287290_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81460_, (Object)pos.m_252807_()));
        RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
        for (ItemStack stack : drops) {
            rollingStock.offerOrDropItem(stack);
        }
        RailShape trackShape = TrackUtil.getRailShapeRaw(state);
        this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
        return trackShape;
    }

    public static enum Mode implements ButtonState<Mode>,
    StringRepresentable
    {
        ON("on", 0.1f),
        OFF("off", 0.4f);

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;
        private final float speed;

        private Mode(String name, float speed) {
            this.name = name;
            this.speed = speed;
        }

        public float speed() {
            return this.speed;
        }

        @Override
        public Component label() {
            return Component.m_237115_((String)this.getTranslationKey());
        }

        public String getTranslationKey() {
            return Translations.makeKey("screen", "cart.maintenance.mode." + this.name);
        }

        public String getTipsKey() {
            return Translations.makeKey("tips", "cart.maintenance.mode." + this.name);
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.SMALL_BUTTON;
        }

        @Override
        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public static Mode fromName(String name) {
            return (Mode)CODEC.m_262792_(name, (Enum)ON);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Mode::values);
        }
    }
}

