/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.inventory.EnergyMinecartMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyMinecart
extends RailcraftMinecart {
    private static final int MAX_CHARGE = 50000;
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(EnergyMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final CartStorage energyStorage = new CartStorage();
    private final LazyOptional<IEnergyStorage> cartBattery = LazyOptional.of(() -> this.energyStorage);

    public EnergyMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public EnergyMinecart(ItemStack itemStack, double x, double y, double z, Level level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.ENERGY_MINECART.get(), x, y, z, level);
        this.loadFromItemStack(itemStack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENERGY, (Object)0);
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        super.m_6401_(pos, state);
        if (!this.m_9236_().f_46443_) {
            int drawnFromTrack = Charge.distribution.network((ServerLevel)this.m_9236_()).access(this.m_20183_()).removeCharge(this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored(), false);
            this.energyStorage.receiveEnergy(drawnFromTrack, false);
        }
    }

    public int m_6643_() {
        return 0;
    }

    public IEnergyStorage getCartBattery() {
        return this.energyStorage;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return ForgeCapabilities.ENERGY == capability ? this.cartBattery.cast() : super.getCapability(capability, facing);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.energyStorage.setEnergyStored(tag.m_128451_("energy"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("energy")) {
            this.energyStorage.setEnergyStored(tag.m_128451_("energy"));
        }
    }

    @Override
    public ItemStack m_142340_() {
        ItemStack itemStack = super.m_142340_();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        return itemStack;
    }

    @Override
    public Item m_213728_() {
        return (Item)RailcraftItems.ENERGY_MINECART.get();
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return new EnergyMinecartMenu(id, playerInventory, this);
    }

    private class CartStorage
    implements IEnergyStorage {
        private CartStorage() {
        }

        public int getEnergyStored() {
            return (Integer)EnergyMinecart.this.f_19804_.m_135370_(ENERGY);
        }

        public void setEnergyStored(int amount) {
            EnergyMinecart.this.f_19804_.m_135381_(ENERGY, (Object)amount);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyReceived = Math.min(50000 - energyStored, maxReceive);
            if (!simulate) {
                this.setEnergyStored(energyStored + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyExtracted = Math.min(energyStored, maxExtract);
            if (!simulate) {
                this.setEnergyStored(energyStored - energyExtracted);
            }
            return energyExtracted;
        }

        public int getMaxEnergyStored() {
            return 50000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

