/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.track;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;

public final class TrackScanUtil {
    private TrackScanUtil() {
    }

    public static boolean areTracksConnectedAlongAxis(Level level, BlockPos start, BlockPos end) {
        return TrackScanUtil.scanStraightTrackSection(level, start, end).status() == Status.VALID;
    }

    public static Result scanStraightTrackSection(Level level, BlockPos start, BlockPos end) {
        int maxY;
        int minY;
        block14: {
            int yy;
            int max;
            int z2;
            int y2;
            int z1;
            int y1;
            int x1;
            block13: {
                int yy2;
                int max2;
                x1 = start.m_123341_();
                y1 = start.m_123342_();
                z1 = start.m_123343_();
                int x2 = end.m_123341_();
                y2 = end.m_123342_();
                z2 = end.m_123343_();
                minY = Math.min(y1, y2);
                maxY = Math.max(y1, y2);
                if (x1 != x2 && z1 != z2) {
                    return new Result(Status.NOT_ALIGNED, minY, maxY);
                }
                if (x1 == x2) break block13;
                if (x1 < x2) {
                    min = x1;
                    max2 = x2;
                    yy2 = y1;
                } else {
                    min = x2;
                    max2 = x1;
                    yy2 = y2;
                }
                for (int xx = min; xx <= max2; ++xx) {
                    BlockPos p = new BlockPos(xx, yy2, z1);
                    if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p)) continue;
                    if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p.m_7495_())) {
                        if (--yy2 >= minY) continue;
                        minY = yy2;
                        continue;
                    }
                    if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p.m_7494_())) {
                        if (++yy2 <= maxY) continue;
                        maxY = yy2;
                        continue;
                    }
                    if (!level.m_46749_(p)) {
                        return new Result(Status.UNKNOWN, minY, maxY);
                    }
                    return new Result(Status.PATH_NOT_FOUND, minY, maxY);
                }
                break block14;
            }
            if (z1 == z2) break block14;
            if (z1 < z2) {
                min = z1;
                max = z2;
                yy = y1;
            } else {
                min = z2;
                max = z1;
                yy = y2;
            }
            for (int zz = min; zz <= max; ++zz) {
                BlockPos p = new BlockPos(x1, yy, zz);
                if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p)) continue;
                if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p.m_7495_())) {
                    if (--yy >= minY) continue;
                    minY = yy;
                    continue;
                }
                if (BaseRailBlock.m_49364_((Level)level, (BlockPos)p.m_7494_())) {
                    if (++yy <= maxY) continue;
                    maxY = yy;
                    continue;
                }
                if (!level.m_46749_(p)) {
                    return new Result(Status.UNKNOWN, minY, maxY);
                }
                return new Result(Status.PATH_NOT_FOUND, minY, maxY);
            }
        }
        return new Result(Status.VALID, minY, maxY);
    }

    public record Result(Status status, int minY, int maxY) {
    }

    public static enum Status {
        VALID,
        UNKNOWN,
        NOT_ALIGNED,
        PATH_NOT_FOUND;


        public boolean valid() {
            return this == VALID;
        }

        public boolean unknown() {
            return this == UNKNOWN;
        }
    }
}

