/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.ids.AECreativeTabIds;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;

public final class MainCreativeTab {
    private static final Multimap<ResourceKey<CreativeModeTab>, ItemDefinition<?>> externalItemDefs = HashMultimap.create();
    private static final List<ItemDefinition<?>> itemDefs = new ArrayList();

    public static void init(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().m_257941_((Component)GuiText.CreativeTab.text()).m_257737_(() -> AEBlocks.CONTROLLER.stack(1)).m_257501_(MainCreativeTab::buildDisplayItems).m_257652_();
        Registry.m_194579_(registry, AECreativeTabIds.MAIN, (Object)tab);
    }

    public static void initExternal(BuildCreativeModeTabContentsEvent contents) {
        for (ItemDefinition itemDefinition : externalItemDefs.get((Object)contents.getTabKey())) {
            contents.m_246326_((ItemLike)itemDefinition);
        }
    }

    public static void add(ItemDefinition<?> itemDef) {
        itemDefs.add(itemDef);
    }

    public static void addExternal(ResourceKey<CreativeModeTab> tab, ItemDefinition<?> itemDef) {
        externalItemDefs.put(tab, itemDef);
    }

    private static void buildDisplayItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        for (ItemDefinition<?> itemDef : itemDefs) {
            AEBaseBlockItem baseItem;
            Block block;
            Object item = itemDef.m_5456_();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)((Object)item)).m_40614_()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)((Object)item);
                baseItem2.addToMainCreativeTab(output);
                continue;
            }
            output.m_246326_(itemDef);
        }
    }
}

