/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.structure;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import mods.railcraft.api.core.RailcraftConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ComponentWorkshop {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("empty"));

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation templatePoolName, ResourceLocation newStructureName, int frequency) {
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(templatePoolName);
        if (pool == null) {
            return;
        }
        LegacySinglePoolElement piece = (LegacySinglePoolElement)SinglePoolElement.m_210512_((String)newStructureName.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < frequency; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)frequency));
        pool.f_210559_ = listOfPieceEntries;
    }

    public static void addVillageStructures(RegistryAccess.Frozen registryAccess) {
        Registry templatePoolRegistry = (Registry)registryAccess.m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)registryAccess.m_6632_(Registries.f_257011_).orElseThrow();
        ComponentWorkshop.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("village/plains/houses"), RailcraftConstants.rl("component_workshop_cartman"), 3);
        ComponentWorkshop.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("village/plains/houses"), RailcraftConstants.rl("component_workshop_trackman"), 5);
    }
}

