/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.ArrayList;
import mods.railcraft.world.item.LocomotiveItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class LocomotivePaintingRecipe
extends CustomRecipe {
    public LocomotivePaintingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    private ItemStack getItemStackInRow(CraftingContainer container, int row) {
        int width = container.m_39347_();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_39347_(); ++i) {
            ItemStack item = container.m_8020_(row * width + i);
            if (item.m_41619_()) continue;
            result.add(item);
        }
        return result.size() != 1 ? ItemStack.f_41583_ : (ItemStack)result.get(0);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack dyePrimary = this.getItemStackInRow(container, 0);
        if (!(dyePrimary.m_41720_() instanceof DyeItem)) {
            return false;
        }
        ItemStack loco = this.getItemStackInRow(container, 1);
        if (!(loco.m_41720_() instanceof LocomotiveItem)) {
            return false;
        }
        ItemStack dyeSecondary = this.getItemStackInRow(container, 2);
        return dyeSecondary.m_41720_() instanceof DyeItem;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack dyePrimary = this.getItemStackInRow(container, 0);
        ItemStack loco = this.getItemStackInRow(container, 1);
        ItemStack dyeSecondary = this.getItemStackInRow(container, 2);
        Item item = dyePrimary.m_41720_();
        if (!(item instanceof DyeItem)) {
            return ItemStack.f_41583_;
        }
        DyeItem primaryItem = (DyeItem)item;
        Item item2 = loco.m_41720_();
        if (!(item2 instanceof LocomotiveItem)) {
            return ItemStack.f_41583_;
        }
        LocomotiveItem locomotiveItem = (LocomotiveItem)item2;
        Item item3 = dyeSecondary.m_41720_();
        if (!(item3 instanceof DyeItem)) {
            return ItemStack.f_41583_;
        }
        DyeItem secondaryItem = (DyeItem)item3;
        DyeColor primaryColor = primaryItem.m_41089_();
        DyeColor secondaryColor = secondaryItem.m_41089_();
        ItemStack result = new ItemStack((ItemLike)locomotiveItem);
        CompoundTag tag = loco.m_41783_();
        if (tag != null) {
            result.m_41751_(tag);
        }
        LocomotiveItem.setItemColorData(result, primaryColor, secondaryColor);
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        ingredients.set(1, (Object)Ingredient.m_204132_((TagKey)Tags.Items.DYES));
        ingredients.set(4, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get()}));
        ingredients.set(7, (Object)Ingredient.m_204132_((TagKey)Tags.Items.DYES));
        return ingredients;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get());
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.LOCOMOTIVE_PAINTING.get();
    }
}

