/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackUndercutterMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class TrackUndercutter
extends MaintenancePatternMinecart {
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;
    public static final int SLOT_EXIST_UNDER_A = 0;
    public static final int SLOT_EXIST_UNDER_B = 1;
    public static final int SLOT_EXIST_SIDE_A = 2;
    public static final int SLOT_EXIST_SIDE_B = 3;
    public static final int SLOT_REPLACE_UNDER = 4;
    public static final int SLOT_REPLACE_SIDE = 5;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 2);

    public TrackUndercutter(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackUndercutter(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TRACK_UNDERCUTTER.get(), x, y, z, (Level)level);
    }

    @Override
    public Item m_213728_() {
        return (Item)RailcraftItems.TRACK_UNDERCUTTER.get();
    }

    @Override
    public void m_8119_() {
        BlockState blockState;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        BlockPos pos = BlockPos.m_274446_((Position)this.m_20182_());
        if (BaseRailBlock.m_49364_((Level)this.m_9236_(), (BlockPos)pos.m_7495_())) {
            pos = pos.m_7495_();
        }
        if (!BaseRailBlock.m_49416_((BlockState)(blockState = this.m_9236_().m_8055_(pos)))) {
            return;
        }
        RailShape railShape = TrackUtil.getTrackDirection((BlockGetter)this.m_9236_(), pos, blockState, (AbstractMinecart)this);
        pos = pos.m_7495_();
        boolean slotAEmpty = true;
        boolean slotBEmpty = true;
        if (!this.patternContainer.m_8020_(0).m_41619_()) {
            this.replaceUnder(pos, 0);
            slotAEmpty = false;
        }
        if (!this.patternContainer.m_8020_(1).m_41619_()) {
            this.replaceUnder(pos, 1);
            slotBEmpty = false;
        }
        if (slotAEmpty && slotBEmpty) {
            this.replaceUnder(pos, 0);
        }
        slotAEmpty = true;
        slotBEmpty = true;
        if (!this.patternContainer.m_8020_(2).m_41619_()) {
            this.replaceSide(pos, 2, railShape);
            slotAEmpty = false;
        }
        if (!this.patternContainer.m_8020_(3).m_41619_()) {
            this.replaceSide(pos, 3, railShape);
            slotBEmpty = false;
        }
        if (slotAEmpty && slotBEmpty) {
            this.replaceSide(pos, 2, railShape);
        }
    }

    private void replaceUnder(BlockPos pos, int slotExist) {
        this.replaceWith(pos, slotExist, 0);
    }

    private void replaceSide(BlockPos pos, int slotExist, RailShape railShape) {
        if (RailShapeUtil.isEastWest(railShape)) {
            this.replaceWith(pos.m_122012_(), slotExist, 1);
            this.replaceWith(pos.m_122019_(), slotExist, 1);
        } else if (RailShapeUtil.isNorthSouth(railShape)) {
            this.replaceWith(pos.m_122029_(), slotExist, 1);
            this.replaceWith(pos.m_122024_(), slotExist, 1);
        }
    }

    private void replaceWith(BlockPos pos, int existingSlot, int stockSlot) {
        ItemStack existingTrack = this.patternContainer.m_8020_(existingSlot);
        ItemStack stockTrack = this.m_8020_(stockSlot);
        if (!this.isValidBallast(stockTrack)) {
            return;
        }
        BlockState oldState = this.m_9236_().m_8055_(pos);
        if (!TrackUndercutter.blockMatches(oldState, existingTrack)) {
            return;
        }
        if (this.safeToReplace(pos)) {
            BlockState stockBlock = ContainerTools.getBlockStateFromStack(stockTrack, this.m_9236_(), pos);
            List drops = Block.m_49869_((BlockState)oldState, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)pos, (BlockEntity)this.m_9236_().m_7702_(pos));
            if (stockBlock != null && this.m_9236_().m_46597_(pos, stockBlock)) {
                this.m_9236_().m_5594_(null, pos, stockBlock.m_60827_().m_56777_(), SoundSource.AMBIENT, 1.0f, 0.8f);
                this.m_7407_(stockSlot, 1);
                RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
                for (ItemStack stack : drops) {
                    rollingStock.offerOrDropItem(stack);
                }
                this.blink();
            }
        }
    }

    private boolean safeToReplace(BlockPos pos) {
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (blockState.m_60795_()) {
            return false;
        }
        if (blockState.m_278721_()) {
            return false;
        }
        if (blockState.m_60800_((BlockGetter)this.m_9236_(), pos) < 0.0f) {
            return false;
        }
        return !blockState.m_204336_(RailcraftTags.Blocks.TUNNEL_BORE_REPLACEABLE_BLOCKS);
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    @Override
    public int m_6643_() {
        return 2;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return switch (slot) {
            case 4 -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)this.patternContainer.m_8020_(4));
            case 5 -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)this.patternContainer.m_8020_(5));
            default -> false;
        };
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory inventory) {
        return new TrackUndercutterMenu(id, inventory, this);
    }

    private static boolean blockMatches(BlockState state, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return state.m_60713_(item2.m_40614_()) || state.m_60713_(Blocks.f_50034_) && item2.m_40614_() == Blocks.f_50493_;
        }
        return false;
    }

    public boolean isValidBallast(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        BlockState state = ContainerTools.getBlockStateFromStack(stack);
        if (state.m_204336_(RailcraftTags.Blocks.TRACK_UNDERCUTTER_INVALID_BALLAST)) {
            return false;
        }
        return state.m_60828_((BlockGetter)this.m_9236_(), this.m_20183_());
    }
}

