/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.detector;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetItemDetectorAttributesMessage;
import mods.railcraft.world.inventory.detector.ItemDetectorMenu;
import mods.railcraft.world.level.block.entity.detector.ItemDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class ItemDetectorScreen
extends RailcraftMenuScreen<ItemDetectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = RailcraftConstants.rl("textures/gui/container/item_detector.png");
    private final ItemDetectorBlockEntity itemDetector;
    private Button filterLeft;
    private Button filterRight;

    public ItemDetectorScreen(ItemDetectorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.itemDetector = menu.getItemDetector();
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), __ -> {
            ItemDetectorBlockEntity.PrimaryMode value = this.itemDetector.getPrimaryMode().previous();
            this.itemDetector.setPrimaryMode(value);
            this.sendAttributes();
        }).m_252987_(centreX + 10, centreY + 16, 20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), __ -> {
            ItemDetectorBlockEntity.PrimaryMode value = this.itemDetector.getPrimaryMode().next();
            this.itemDetector.setPrimaryMode(value);
            this.sendAttributes();
        }).m_252987_(centreX + 146, centreY + 16, 20, 20).m_253136_());
        this.filterLeft = Button.m_253074_((Component)Component.m_237113_((String)"<"), __ -> {
            ItemDetectorBlockEntity.FilterMode value = this.itemDetector.getFilterMode().previous();
            this.itemDetector.setFilterMode(value);
            this.sendAttributes();
        }).m_252987_(centreX + 10, centreY + 38, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.filterLeft);
        this.filterRight = Button.m_253074_((Component)Component.m_237113_((String)">"), __ -> {
            ItemDetectorBlockEntity.FilterMode value = this.itemDetector.getFilterMode().next();
            this.itemDetector.setFilterMode(value);
            this.sendAttributes();
        }).m_252987_(centreX + 146, centreY + 38, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.filterRight);
    }

    private void sendAttributes() {
        NetworkChannel.GAME.sendToServer(new SetItemDetectorAttributesMessage(this.itemDetector.m_58899_(), this.itemDetector.getPrimaryMode(), this.itemDetector.getFilterMode()));
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean visible;
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.filterLeft.f_93624_ = visible = this.itemDetector.getPrimaryMode() == ItemDetectorBlockEntity.PrimaryMode.FILTERED;
        this.filterRight.f_93624_ = visible;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, -12566464, false);
        Component primaryModeName = this.itemDetector.getPrimaryMode().getName();
        guiGraphics.m_280614_(this.f_96547_, primaryModeName, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)primaryModeName) / 2, 21, -12566464, false);
        if (this.itemDetector.getPrimaryMode() == ItemDetectorBlockEntity.PrimaryMode.FILTERED) {
            Component filterModeName = this.itemDetector.getFilterMode().getName();
            guiGraphics.m_280614_(this.f_96547_, filterModeName, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)filterModeName) / 2, 43, -12566464, false);
            return;
        }
        int color = FastColor.ARGB32.m_13660_((int)80, (int)0, (int)0, (int)0);
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            Slot slot = (Slot)((ItemDetectorMenu)this.f_97732_).f_38839_.get(slotNum);
            int displayX = slot.f_40220_;
            int displayY = slot.f_40221_;
            guiGraphics.m_285944_(RenderType.m_286086_(), displayX, displayY, displayX + 16, displayY + 16, color);
        }
    }
}

