/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class ChargeSavedData
extends SavedData {
    private static final int ABSENT_VALUE = -1;
    private static final String DATA_TAG_PREFIX = "railcraft.charge.";
    private final Object2IntMap<BlockPos> chargeLevels = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));

    public static ChargeSavedData getFor(Charge network, ServerLevel level) {
        return (ChargeSavedData)level.m_8895_().m_164861_(tag -> {
            ChargeSavedData manager = new ChargeSavedData();
            manager.load((CompoundTag)tag);
            return manager;
        }, ChargeSavedData::new, DATA_TAG_PREFIX + network.m_7912_());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag batteriesTag = new ListTag();
        for (Object2IntMap.Entry entry : this.chargeLevels.object2IntEntrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)entry.getKey())));
            entryTag.m_128405_("value", entry.getIntValue());
            batteriesTag.add((Object)entryTag);
        }
        tag.m_128365_("batteries", (Tag)batteriesTag);
        return tag;
    }

    private void load(CompoundTag tag) {
        ListTag batteriesTag = tag.m_128437_("batteries", 10);
        for (int i = 0; i < batteriesTag.size(); ++i) {
            CompoundTag entryTag = batteriesTag.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_("pos"));
            this.chargeLevels.put((Object)pos, entryTag.m_128451_("value"));
        }
    }

    public void initBattery(ChargeStorageBlockImpl battery) {
        battery.setEnergyStored(this.chargeLevels.computeIfAbsent((Object)battery.getBlockPos(), __ -> battery.getInitialCharge()));
        this.m_77762_();
    }

    public void updateBatteryRecord(ChargeStorageBlockImpl battery) {
        this.chargeLevels.put((Object)battery.getBlockPos(), battery.getEnergyStored());
        this.m_77762_();
    }

    public void removeBattery(BlockPos pos) {
        if (this.chargeLevels.removeInt((Object)pos) != -1) {
            this.m_77762_();
        }
    }
}

