/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;
import org.cyclops.integratedtunnels.core.PlayerHelpers;

public class ItemStoragePlayerWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private static final Predicate<Entity> CAN_BE_ATTACKED = Entity::m_6097_;
    private final ExtendedFakePlayer player;
    private final ServerLevel world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final Direction side;
    private final InteractionHand hand;
    private final boolean rightClick;
    private final boolean sneaking;
    private final boolean continuousClick;
    private final int entityIndex;
    private final IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler;

    public ItemStoragePlayerWrapper(@Nullable ExtendedFakePlayer player, ServerLevel world, BlockPos pos, double offsetX, double offsetY, double offsetZ, Direction side, InteractionHand hand, boolean rightClick, boolean sneaking, boolean continuousClick, int entityIndex, IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.continuousClick = continuousClick;
        this.entityIndex = entityIndex;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.side = side;
        this.hand = hand;
        this.rightClick = rightClick;
        this.sneaking = sneaking;
        this.playerReturnHandler = playerReturnHandler;
    }

    public static void cancelDestroyingBlock(ServerPlayer player) {
        player.f_8941_.f_9249_ = false;
        player.f_8941_.f_9256_ = -1;
    }

    protected Entity getEntity(List<Entity> entities) {
        if (this.entityIndex < 0) {
            return entities.get(this.world.f_46441_.m_188503_(entities.size()));
        }
        return entities.get(Math.min(this.entityIndex, entities.size() - 1));
    }

    private void returnPlayerInventory(Player player) {
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.m_41619_()) continue;
            ItemStack remaining = (ItemStack)this.playerReturnHandler.insert((Object)itemStack, false);
            ItemStackHelpers.spawnItemStackToPlayer((Level)this.world, (BlockPos)this.pos, (ItemStack)remaining, (Player)player);
            it.remove();
        }
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.f_41583_;
        }
        if (this.player == null) {
            return stack;
        }
        PlayerHelpers.setPlayerState((Player)this.player, this.hand, this.pos, this.offsetX, this.offsetY, this.offsetZ, this.side, this.sneaking);
        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, stack.m_41777_());
        if (!this.continuousClick) {
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
        }
        if (this.rightClick) {
            List entities;
            boolean flag1;
            BlockHitResult blockRayTraceResult = new BlockHitResult(new Vec3(this.offsetX, this.offsetY, this.offsetZ), this.side, this.pos, false);
            PlayerInteractEvent.RightClickBlock rightClickBlockActionResult = ForgeHooks.onRightClickBlock((Player)this.player, (InteractionHand)this.hand, (BlockPos)this.pos, (BlockHitResult)blockRayTraceResult);
            if (rightClickBlockActionResult.isCanceled()) {
                return stack;
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.m_41619_()) {
                UseOnContext itemUseContext = new UseOnContext((Player)this.player, this.hand, blockRayTraceResult);
                InteractionResult actionResult = stack.m_41720_().onItemUseFirst(stack, itemUseContext);
                stack = itemUseContext.m_43722_();
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.m_19077_()) {
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.f_41583_;
                }
            }
            boolean playerHasHeldItem = !this.player.m_21205_().m_41619_() || !this.player.m_21206_().m_41619_();
            boolean bl = flag1 = this.player.m_36341_() && playerHasHeldItem && (!this.player.m_21205_().doesSneakBypassUse((LevelReader)this.world, this.pos, (Player)this.player) || !this.player.m_21206_().doesSneakBypassUse((LevelReader)this.world, this.pos, (Player)this.player));
            if (rightClickBlockActionResult.getUseBlock() == Event.Result.ALLOW || rightClickBlockActionResult.getUseBlock() != Event.Result.DENY && !flag1) {
                BlockState blockState = this.world.m_8055_(this.pos);
                if ((!this.player.m_6047_() || stack.m_41619_()) && blockState.m_60664_((Level)this.world, (Player)this.player, this.hand, blockRayTraceResult).m_19077_()) {
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.f_41583_;
                }
            }
            if ((entities = this.world.m_45976_(Entity.class, new AABB(this.pos))).size() > 0) {
                Entity entity = this.getEntity(entities);
                InteractionResult actionResult = this.player.m_36157_(entity, this.hand);
                if (entity instanceof Villager) {
                    Villager villager = (Villager)entity;
                    villager.m_7189_(null);
                }
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.m_19077_()) {
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.f_41583_;
                }
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.m_41619_()) {
                InteractionResult cancelResult = ForgeHooks.onItemRightClick((Player)this.player, (InteractionHand)this.hand);
                if (cancelResult != null) {
                    if (cancelResult == InteractionResult.FAIL) {
                        return stack;
                    }
                    if (cancelResult.m_19077_()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.f_41583_;
                    }
                } else {
                    ItemStack copyBeforeUse = stack.m_41777_();
                    InteractionResultHolder actionresult = stack.m_41682_((Level)this.world, (Player)this.player, this.hand);
                    if (actionresult.m_19089_() == InteractionResult.FAIL) {
                        return stack;
                    }
                    if (((ItemStack)actionresult.m_19095_()).m_41619_()) {
                        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, ItemStack.f_41583_);
                        ForgeEventFactory.onPlayerDestroyItem((Player)this.player, (ItemStack)copyBeforeUse, (InteractionHand)this.hand);
                    } else {
                        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, (ItemStack)actionresult.m_19095_());
                    }
                    if (actionresult.m_19089_().m_19077_()) {
                        if (this.player.m_6117_()) {
                            this.player.updateActiveHandSimulated();
                            this.player.m_21253_();
                        }
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.f_41583_;
                    }
                    if (((ItemStack)actionresult.m_19095_()).m_41619_()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.m_41619_()) {
                BlockPos targetPos = this.pos;
                double reachDistance = this.player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 3.0;
                int i = 0;
                while (true) {
                    int n = i++;
                    if (!((double)n < reachDistance) || !this.world.m_46859_(targetPos)) break;
                    targetPos = targetPos.m_121945_(this.side.m_122424_());
                }
                UseOnContext itemUseContextReach = new UseOnContext((Player)this.player, this.hand, new BlockHitResult(new Vec3(this.offsetX, this.offsetY, this.offsetZ), this.side, targetPos, false));
                InteractionResult actionResult = stack.m_41661_(itemUseContextReach);
                stack = itemUseContextReach.m_43722_();
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.m_19077_()) {
                    if (this.player.m_6117_()) {
                        this.player.updateActiveHandSimulated();
                        this.player.m_21253_();
                    }
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.f_41583_;
                }
            }
        } else {
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)this.player, (BlockPos)this.pos, (Direction)this.side);
            BlockState blockState = this.world.m_8055_(this.pos);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                this.world.m_7260_(this.pos, blockState, this.world.m_8055_(this.pos), 3);
                return stack;
            }
            if (!this.world.m_46859_(this.pos)) {
                int durabilityRemaining = this.player.f_8941_.f_9256_;
                if (durabilityRemaining < 0) {
                    this.world.m_8055_(this.pos).m_60686_((Level)this.world, this.pos, (Player)this.player);
                    float relativeBlockHardness = blockState.m_60625_((Player)this.player, (BlockGetter)this.player.m_9236_(), this.pos);
                    if (relativeBlockHardness >= 1.0f) {
                        this.player.f_8941_.m_9280_(this.pos);
                    } else {
                        this.player.f_8941_.f_9250_ = this.player.f_8941_.f_9252_;
                        this.player.f_8941_.f_9249_ = true;
                        this.player.f_8941_.f_9251_ = this.pos.m_7949_();
                        this.player.f_8941_.f_9256_ = (int)(relativeBlockHardness * 10.0f);
                    }
                } else if (durabilityRemaining >= 9) {
                    this.player.f_8941_.m_9280_(this.pos);
                    ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
                } else {
                    this.player.f_8941_.m_7712_();
                }
                this.returnPlayerInventory((Player)this.player);
                return ItemStack.f_41583_;
            }
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
            List entities = this.world.m_6443_(Entity.class, new AABB(this.pos), CAN_BE_ATTACKED::test);
            if (entities.size() > 0) {
                Entity entity = this.getEntity(entities);
                EquipmentSlot equipmentSlotType = this.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                this.player.m_21204_().m_22178_(stack.m_41638_(equipmentSlotType));
                this.player.m_5706_(entity);
                this.player.m_21204_().m_22161_(stack.m_41638_(equipmentSlotType));
                this.returnPlayerInventory((Player)this.player);
                return ItemStack.f_41583_;
            }
            return stack;
        }
        return stack;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void onTameAnimal(AnimalTameEvent event) {
        if (event.getTamer() instanceof ExtendedFakePlayer) {
            event.setCanceled(true);
        }
    }
}

