/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.betterrespawn.mixin;

import de.maxhenkel.betterrespawn.RespawnAbilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Abilities.class})
public class AbilitiesMixin
implements RespawnAbilities {
    private ResourceKey<Level> respawnDimension;
    @Nullable
    private BlockPos respawnPos;
    private float respawnAngle;
    private boolean respawnForced;

    @Inject(method={"addSaveData"}, at={@At(value="RETURN")})
    private void addSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        CompoundTag abilities = compoundTag.m_128469_("abilities");
        CompoundTag betterRespawn = new CompoundTag();
        if (this.respawnDimension != null) {
            betterRespawn.m_128359_("respawn_dimension", this.respawnDimension.m_135782_().toString());
        }
        if (this.respawnPos != null) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.respawnPos.m_123341_());
            pos.m_128405_("y", this.respawnPos.m_123342_());
            pos.m_128405_("z", this.respawnPos.m_123343_());
            betterRespawn.m_128365_("respawn_pos", (Tag)pos);
        }
        betterRespawn.m_128350_("respawn_angle", this.respawnAngle);
        betterRespawn.m_128379_("respawn_forced", this.respawnForced);
        abilities.m_128365_("better_respawn", (Tag)betterRespawn);
    }

    @Inject(method={"loadSaveData"}, at={@At(value="RETURN")})
    private void loadSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (!compoundTag.m_128425_("abilities", 10)) {
            return;
        }
        CompoundTag abilities = compoundTag.m_128469_("abilities");
        if (abilities.m_128441_("better_respawn")) {
            CompoundTag betterRespawn = abilities.m_128469_("better_respawn");
            this.respawnDimension = betterRespawn.m_128441_("respawn_dimension") ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(betterRespawn.m_128461_("respawn_level"))) : Level.f_46428_;
            if (betterRespawn.m_128441_("respawn_pos")) {
                CompoundTag pos = betterRespawn.m_128469_("respawn_pos");
                this.respawnPos = new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
            } else {
                this.respawnPos = null;
            }
            this.respawnAngle = betterRespawn.m_128441_("respawn_angle") ? betterRespawn.m_128457_("respawn_angle") : 0.0f;
            this.respawnForced = betterRespawn.m_128441_("respawn_forced") ? betterRespawn.m_128471_("respawn_forced") : false;
        } else {
            this.respawnDimension = Level.f_46428_;
            this.respawnPos = null;
            this.respawnAngle = 0.0f;
            this.respawnForced = false;
        }
    }

    @Override
    public void setRespawnDimension(ResourceKey<Level> dimension) {
        this.respawnDimension = dimension;
    }

    @Override
    public void setRespawnPos(@Nullable BlockPos pos) {
        this.respawnPos = pos;
    }

    @Override
    public void setRespawnAngle(float angle) {
        this.respawnAngle = angle;
    }

    @Override
    public void setRespawnForced(boolean forced) {
        this.respawnForced = forced;
    }

    @Override
    public ResourceKey<Level> getRespawnDimension() {
        return this.respawnDimension;
    }

    @Override
    @Nullable
    public BlockPos getRespawnPos() {
        return this.respawnPos;
    }

    @Override
    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    @Override
    public boolean getRespawnForced() {
        return this.respawnForced;
    }
}

