/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.betterrespawn;

import de.maxhenkel.betterrespawn.BetterRespawnMod;
import de.maxhenkel.betterrespawn.RespawnAbilities;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RespawnManager {
    private static final int FIND_SPAWN_ATTEMPTS = 16;
    private final Random random = new Random();

    public void onPlayerDeath(ServerPlayer player) {
        Optional respawnVector;
        Abilities abilities = player.m_150110_();
        if (!(abilities instanceof RespawnAbilities)) {
            return;
        }
        RespawnAbilities respawnAbilities = (RespawnAbilities)abilities;
        respawnAbilities.setRespawnDimension((ResourceKey<Level>)player.m_8963_());
        respawnAbilities.setRespawnPos(player.m_8961_());
        respawnAbilities.setRespawnAngle(player.m_8962_());
        respawnAbilities.setRespawnForced(player.m_8964_());
        ServerLevel respawnDimension = player.m_20194_().m_129880_(player.m_8963_());
        BlockPos respawnLocation = player.m_8961_();
        float respawnAngle = player.m_8962_();
        if (respawnLocation != null && (respawnVector = Player.m_36130_((ServerLevel)(respawnDimension == null ? player.m_284548_() : respawnDimension), (BlockPos)respawnLocation, (float)respawnAngle, (boolean)false, (boolean)true)).isPresent()) {
            Vec3 spawn = (Vec3)respawnVector.get();
            if (respawnDimension == player.m_284548_() && player.m_20183_().m_123333_(new Vec3i((int)spawn.f_82479_, (int)spawn.f_82480_, (int)spawn.f_82481_)) <= BetterRespawnMod.SERVER_CONFIG.respawnBlockRange.get()) {
                BetterRespawnMod.LOGGER.info("Player {} is within the range of its respawn block", (Object)player.m_7755_().getString());
                return;
            }
        }
        if (player.m_284548_().m_6042_().f_63856_() || !player.m_284548_().m_6042_().f_63862_()) {
            BetterRespawnMod.LOGGER.info("Can't respawn {} in {}", (Object)player.m_7755_().getString(), (Object)player.m_284548_().m_46472_().m_135782_());
            return;
        }
        BlockPos respawnPos = this.findValidRespawnLocation(player.m_284548_(), player.m_20183_());
        if (respawnPos == null) {
            return;
        }
        player.m_9158_(player.m_284548_().m_46472_(), respawnPos, 0.0f, true, true);
        BetterRespawnMod.LOGGER.info("Set temporary respawn location to [{}, {}, {}]", (Object)respawnPos.m_123341_(), (Object)respawnPos.m_123342_(), (Object)respawnPos.m_123343_());
    }

    public void onSetRespawnPosition(ServerPlayer player, ResourceKey<Level> dimension, @Nullable BlockPos pos, float angle, boolean forced, boolean showMessage) {
        if (forced) {
            return;
        }
        Abilities abilities = player.m_150110_();
        if (!(abilities instanceof RespawnAbilities)) {
            return;
        }
        RespawnAbilities abilities2 = (RespawnAbilities)abilities;
        if (pos == null) {
            dimension = Level.f_46428_;
        }
        abilities2.setRespawnDimension((ResourceKey<Level>)dimension);
        abilities2.setRespawnPos(pos);
        abilities2.setRespawnAngle(angle);
        abilities2.setRespawnForced(forced);
        if (pos != null) {
            BetterRespawnMod.LOGGER.info("Updating the respawn location of player {} to [{}, {}, {}] in {}", (Object)player.m_7755_().getString(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_(), (Object)dimension.m_135782_());
        } else {
            BetterRespawnMod.LOGGER.info("Updating the respawn location of player {} to [NONE]", (Object)player.m_7755_().getString());
        }
    }

    @Nullable
    public BlockPos findValidRespawnLocation(ServerLevel world, BlockPos deathLocation) {
        int min = BetterRespawnMod.SERVER_CONFIG.minRespawnDistance.get();
        int max = BetterRespawnMod.SERVER_CONFIG.maxRespawnDistance.get();
        BlockPos pos = null;
        for (int i = 0; i < 16 && pos == null; ++i) {
            BetterRespawnMod.LOGGER.info("Searching for respawn location - Attempt {}/{}", (Object)(i + 1), (Object)16);
            pos = PlayerRespawnLogic.m_183932_((ServerLevel)world, (ChunkPos)new ChunkPos(new BlockPos(this.getRandomRange(deathLocation.m_123341_(), min, max), 0, this.getRandomRange(deathLocation.m_123343_(), min, max))));
            if (pos == null || world.m_6857_().m_61937_(pos)) continue;
            pos = null;
        }
        if (pos == null) {
            BetterRespawnMod.LOGGER.info("Found no valid respawn location after {} attempts", (Object)16);
        } else {
            BetterRespawnMod.LOGGER.info("Found valid respawn location: [{}, {}, {}]", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        return pos;
    }

    private int getRandomRange(int actual, int minDistance, int maxDistance) {
        return actual + (this.random.nextBoolean() ? -1 : 1) * (minDistance + this.random.nextInt(maxDistance - minDistance));
    }
}

